/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateTenantCommandStep1;
import io.camunda.client.api.response.UpdateTenantResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateTenantResponseImpl;
import io.camunda.client.protocol.rest.TenantUpdateRequest;
import io.camunda.client.protocol.rest.TenantUpdateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class UpdateTenantCommandImpl
implements UpdateTenantCommandStep1 {
    private final TenantUpdateRequest request = new TenantUpdateRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String tenantId;

    public UpdateTenantCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, String tenantId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.tenantId = tenantId;
    }

    @Override
    public UpdateTenantCommandStep1 name(String name) {
        this.request.setName(name);
        return this;
    }

    @Override
    public UpdateTenantCommandStep1 description(String description) {
        this.request.setDescription(description);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateTenantResponse> send() {
        HttpCamundaFuture<UpdateTenantResponse> result = new HttpCamundaFuture<UpdateTenantResponse>();
        UpdateTenantResponseImpl response = new UpdateTenantResponseImpl();
        this.httpClient.put("/tenants/" + this.tenantId, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), TenantUpdateResult.class, response::setResponse, result);
        return result;
    }
}

