/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateUserTaskCommandStep1;
import io.camunda.client.api.response.UpdateUserTaskResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateUserTaskResponseImpl;
import io.camunda.client.protocol.rest.Changeset;
import io.camunda.client.protocol.rest.UserTaskUpdateRequest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class UpdateUserTaskCommandImpl
implements UpdateUserTaskCommandStep1 {
    private final long userTaskKey;
    private final UserTaskUpdateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UpdateUserTaskCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskUpdateRequest();
    }

    @Override
    public FinalCommandStep<UpdateUserTaskResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateUserTaskResponse> send() {
        HttpCamundaFuture<UpdateUserTaskResponse> result = new HttpCamundaFuture<UpdateUserTaskResponse>();
        this.httpClient.patch("/user-tasks/" + this.userTaskKey, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UpdateUserTaskResponseImpl::new, result);
        return result;
    }

    @Override
    public UpdateUserTaskCommandStep1 action(String action) {
        this.request.setAction(action);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 dueDate(String dueDate) {
        ArgumentUtil.ensureNotNull("dueDate", dueDate);
        this.getChangesetEnsureInitialized().put("dueDate", dueDate);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearDueDate() {
        this.getChangesetEnsureInitialized().put("dueDate", "");
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 followUpDate(String followUpDate) {
        ArgumentUtil.ensureNotNull("followUpDate", followUpDate);
        this.getChangesetEnsureInitialized().put("followUpDate", followUpDate);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearFollowUpDate() {
        this.getChangesetEnsureInitialized().put("followUpDate", "");
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateGroups(List<String> candidateGroups) {
        ArgumentUtil.ensureNotNull("candidateGroups", candidateGroups);
        this.getChangesetEnsureInitialized().put("candidateGroups", candidateGroups);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateGroups(String ... candidateGroups) {
        ArgumentUtil.ensureNotNull("candidateGroups", candidateGroups);
        this.getChangesetEnsureInitialized().put("candidateGroups", Arrays.asList(candidateGroups));
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearCandidateGroups() {
        this.getChangesetEnsureInitialized().put("candidateGroups", Collections.emptyList());
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateUsers(List<String> candidateUsers) {
        ArgumentUtil.ensureNotNull("candidateUsers", candidateUsers);
        this.getChangesetEnsureInitialized().put("candidateUsers", candidateUsers);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateUsers(String ... candidateUsers) {
        ArgumentUtil.ensureNotNull("candidateUsers", candidateUsers);
        this.getChangesetEnsureInitialized().put("candidateUsers", Arrays.asList(candidateUsers));
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearCandidateUsers() {
        this.getChangesetEnsureInitialized().put("candidateUsers", Collections.emptyList());
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 priority(Integer priority) {
        this.getChangesetEnsureInitialized().put("priority", priority);
        return this;
    }

    private Changeset getChangesetEnsureInitialized() {
        Changeset changeset = this.request.getChangeset();
        if (changeset == null) {
            changeset = new Changeset();
            this.request.setChangeset(changeset);
        }
        return changeset;
    }
}

