/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.DocumentContentGetRequest;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DocumentContentGetRequestImpl
implements DocumentContentGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String documentId;
    private String storeId;
    private String contentHash;

    public DocumentContentGetRequestImpl(HttpClient httpClient, String documentId, String storeId, String contentHash, CamundaClientConfiguration configuration) {
        ArgumentUtil.ensureNotNull("documentId", documentId);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.documentId = documentId;
        this.storeId = storeId;
        this.contentHash = contentHash;
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public FinalCommandStep<InputStream> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<InputStream> send() {
        HttpCamundaFuture<InputStream> result = new HttpCamundaFuture<InputStream>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.storeId != null) {
            queryParams.put("storeId", this.storeId);
        }
        queryParams.put("contentHash", this.contentHash);
        this.httpClient.get(String.format("/documents/%s", this.documentId), queryParams, this.httpRequestConfig.build(), InputStream.class, is -> is, result);
        return result;
    }

    @Override
    public DocumentContentGetRequest storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public DocumentContentGetRequest contentHash(String contentHash) {
        this.contentHash = contentHash;
        return this;
    }
}

