/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.DecisionRequirementsSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.DecisionRequirements;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.DecisionRequirementsSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestPageImpl;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.DecisionRequirementsFilter;
import io.camunda.client.protocol.rest.DecisionRequirementsSearchQuery;
import io.camunda.client.protocol.rest.DecisionRequirementsSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionRequirementsSearchRequestImpl
extends TypedSearchRequestPropertyProvider<DecisionRequirementsSearchQuery>
implements DecisionRequirementsSearchRequest {
    private final DecisionRequirementsSearchQuery request = new DecisionRequirementsSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionRequirementsSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<DecisionRequirements> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpCamundaFuture<SearchResponse<DecisionRequirements>> send() {
        HttpCamundaFuture<SearchResponse<DecisionRequirements>> result = new HttpCamundaFuture<SearchResponse<DecisionRequirements>>();
        this.httpClient.post("/decision-requirements/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionRequirementsSearchQueryResult.class, SearchResponseMapper::toDecisionRequirementsSearchResponse, result);
        return result;
    }

    @Override
    public DecisionRequirementsSearchRequest filter(io.camunda.client.api.search.filter.DecisionRequirementsFilter value) {
        this.request.setFilter((DecisionRequirementsFilter)DecisionRequirementsSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public DecisionRequirementsSearchRequest filter(Consumer<io.camunda.client.api.search.filter.DecisionRequirementsFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionRequirementsFilter(fn));
    }

    @Override
    public DecisionRequirementsSearchRequest sort(DecisionRequirementsSort value) {
        this.request.setSort(SearchRequestSortMapper.toDecisionRequirementsSearchQuerySortRequest((List)DecisionRequirementsSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public DecisionRequirementsSearchRequest sort(Consumer<DecisionRequirementsSort> fn) {
        return this.sort(SearchRequestBuilders.decisionRequirementsSort(fn));
    }

    @Override
    public DecisionRequirementsSearchRequest page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public DecisionRequirementsSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionRequirementsSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

