/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.UserTaskFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UserTaskSearchRequest;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.client.api.search.sort.UserTaskSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.UserTaskSearchQuery;
import io.camunda.client.protocol.rest.UserTaskSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UserTaskSearchRequestImpl
extends TypedSearchRequestPropertyProvider<UserTaskSearchQuery>
implements UserTaskSearchRequest {
    private final UserTaskSearchQuery request = new UserTaskSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UserTaskSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<UserTask> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpCamundaFuture<SearchResponse<UserTask>> send() {
        HttpCamundaFuture<SearchResponse<UserTask>> result = new HttpCamundaFuture<SearchResponse<UserTask>>();
        this.httpClient.post("/user-tasks/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UserTaskSearchQueryResult.class, SearchResponseMapper::toUserTaskSearchResponse, result);
        return result;
    }

    @Override
    public UserTaskSearchRequest filter(UserTaskFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.UserTaskFilter)UserTaskSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UserTaskSearchRequest filter(Consumer<UserTaskFilter> fn) {
        return this.filter(SearchRequestBuilders.userTaskFilter(fn));
    }

    @Override
    public UserTaskSearchRequest sort(UserTaskSort value) {
        this.request.setSort(SearchRequestSortMapper.toUserTaskSearchQuerySortRequest((List)UserTaskSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UserTaskSearchRequest sort(Consumer<UserTaskSort> fn) {
        return this.sort(SearchRequestBuilders.userTaskSort(fn));
    }

    @Override
    public UserTaskSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UserTaskSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UserTaskSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected UserTaskSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

