/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.statistics.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.statistics.request.ProcessInstanceElementStatisticsRequest;
import io.camunda.client.api.statistics.response.ProcessElementStatistics;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.statistics.response.StatisticsResponseMapper;
import io.camunda.client.protocol.rest.ProcessDefinitionElementStatisticsQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceElementStatisticsRequestImpl
implements ProcessInstanceElementStatisticsRequest {
    private final long processInstanceKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessInstanceElementStatisticsRequestImpl(HttpClient httpClient, long processInstanceKey) {
        this.httpClient = httpClient;
        this.processInstanceKey = processInstanceKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<List<ProcessElementStatistics>> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<List<ProcessElementStatistics>> send() {
        HttpCamundaFuture<List<ProcessElementStatistics>> result = new HttpCamundaFuture<List<ProcessElementStatistics>>();
        this.httpClient.get("/process-instances/" + this.processInstanceKey + "/statistics/element-instances", this.httpRequestConfig.build(), ProcessDefinitionElementStatisticsQueryResult.class, StatisticsResponseMapper::toProcessDefinitionStatisticsResponse, result);
        return result;
    }
}

