/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"variables", "local", "operationReference"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SetVariableRequest {
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    @Nonnull
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_LOCAL = "local";
    @Nullable
    private Boolean local = false;
    public static final String JSON_PROPERTY_OPERATION_REFERENCE = "operationReference";
    @Nullable
    private Long operationReference;

    public SetVariableRequest variables(@Nonnull Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public SetVariableRequest putVariablesItem(String key, Object variablesItem) {
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public void setVariables(@Nonnull Map<String, Object> variables) {
        this.variables = variables;
    }

    public SetVariableRequest local(@Nullable Boolean local) {
        this.local = local;
        return this;
    }

    @Nullable
    @JsonProperty(value="local")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLocal() {
        return this.local;
    }

    @JsonProperty(value="local")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocal(@Nullable Boolean local) {
        this.local = local;
    }

    public SetVariableRequest operationReference(@Nullable Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Nullable
    @JsonProperty(value="operationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOperationReference() {
        return this.operationReference;
    }

    @JsonProperty(value="operationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationReference(@Nullable Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetVariableRequest setVariableRequest = (SetVariableRequest)o;
        return Objects.equals(this.variables, setVariableRequest.variables) && Objects.equals(this.local, setVariableRequest.local) && Objects.equals(this.operationReference, setVariableRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.local, this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetVariableRequest {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    local: ").append(this.toIndentedString(this.local)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                try {
                    joiner.add(String.format("%svariables%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getVariables().get(_key), URLEncoder.encode(String.valueOf(this.getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLocal() != null) {
            try {
                joiner.add(String.format("%slocal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLocal()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOperationReference() != null) {
            try {
                joiner.add(String.format("%soperationReference%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOperationReference()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

