/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.AnnotationUtil;
import io.camunda.client.annotation.value.DeploymentValue;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.bean.BeanInfo;
import io.camunda.client.spring.annotation.processor.AbstractCamundaAnnotationProcessor;
import io.camunda.client.spring.event.CamundaPostDeploymentSpringEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class DeploymentAnnotationProcessor
extends AbstractCamundaAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentAnnotationProcessor.class);
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver();
    private final List<DeploymentValue> deploymentValues = new ArrayList<DeploymentValue>();
    private final ApplicationEventPublisher publisher;

    public DeploymentAnnotationProcessor(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public boolean isApplicableFor(BeanInfo beanInfo) {
        return AnnotationUtil.isDeployment(beanInfo);
    }

    @Override
    public void configureFor(BeanInfo beanInfo) {
        Optional<DeploymentValue> zeebeDeploymentValue = AnnotationUtil.getDeploymentValue(beanInfo);
        if (zeebeDeploymentValue.isPresent()) {
            LOGGER.info("Configuring deployment: {}", (Object)zeebeDeploymentValue.get());
            this.deploymentValues.add(zeebeDeploymentValue.get());
        }
    }

    @Override
    public void start(CamundaClient client) {
        List resources = this.deploymentValues.stream().flatMap(d -> d.getResources().stream()).flatMap(r -> Arrays.stream(this.getResources((String)r))).distinct().toList();
        if (resources.isEmpty()) {
            if (this.deploymentValues.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("No resources found to deploy");
        }
        DeployResourceCommandStep1 command = client.newDeployResourceCommand();
        DeployResourceCommandStep1.DeployResourceCommandStep2 commandStep2 = null;
        for (Resource resource : resources) {
            try {
                InputStream inputStream = resource.getInputStream();
                try {
                    if (commandStep2 == null) {
                        commandStep2 = command.addResourceStream(inputStream, resource.getFilename());
                        continue;
                    }
                    commandStep2 = commandStep2.addResourceStream(inputStream, resource.getFilename());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading resource: " + e.getMessage(), e);
            }
        }
        DeploymentEvent deploymentEvent = (DeploymentEvent)commandStep2.send().join();
        LOGGER.info("Deployed: {}", (Object)Stream.concat(deploymentEvent.getDecisionRequirements().stream().map(wf -> String.format("<%s:%d>", wf.getDmnDecisionRequirementsId(), wf.getVersion())), deploymentEvent.getProcesses().stream().map(wf -> String.format("<%s:%d>", wf.getBpmnProcessId(), wf.getVersion()))).collect(Collectors.joining(",")));
        this.publisher.publishEvent((ApplicationEvent)new CamundaPostDeploymentSpringEvent(this, deploymentEvent));
    }

    @Override
    public void stop(CamundaClient client) {
    }

    public Resource[] getResources(String resources) {
        try {
            return RESOURCE_RESOLVER.getResources(resources);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }
}

