/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.AnnotationUtil;
import io.camunda.client.annotation.customizer.JobWorkerValueCustomizer;
import io.camunda.client.annotation.value.JobWorkerValue;
import io.camunda.client.bean.BeanInfo;
import io.camunda.client.jobhandling.JobWorkerManager;
import io.camunda.client.spring.annotation.processor.AbstractCamundaAnnotationProcessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class JobWorkerAnnotationProcessor
extends AbstractCamundaAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerAnnotationProcessor.class);
    private final JobWorkerManager jobWorkerManager;
    private final List<JobWorkerValue> jobWorkerValues = new ArrayList<JobWorkerValue>();
    private final List<JobWorkerValueCustomizer> jobWorkerValueCustomizers;

    public JobWorkerAnnotationProcessor(JobWorkerManager jobWorkerFactory, List<JobWorkerValueCustomizer> jobWorkerValueCustomizers) {
        this.jobWorkerManager = jobWorkerFactory;
        this.jobWorkerValueCustomizers = jobWorkerValueCustomizers;
    }

    @Override
    public boolean isApplicableFor(BeanInfo beanInfo) {
        return AnnotationUtil.isJobWorker(beanInfo);
    }

    @Override
    public void configureFor(BeanInfo beanInfo) {
        ArrayList newJobWorkerValues = new ArrayList();
        ReflectionUtils.doWithMethods(beanInfo.getTargetClass(), method -> AnnotationUtil.getJobWorkerValue(beanInfo.toMethodInfo(method)).ifPresent(newJobWorkerValues::add), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        LOGGER.info("Configuring {} Job worker(s) of bean '{}': {}", new Object[]{newJobWorkerValues.size(), beanInfo.getBeanName(), newJobWorkerValues});
        this.jobWorkerValues.addAll(newJobWorkerValues);
    }

    @Override
    public void start(CamundaClient client) {
        this.jobWorkerValues.stream().peek(jobWorkerValue -> this.jobWorkerValueCustomizers.forEach(customizer -> customizer.customize((JobWorkerValue)jobWorkerValue))).filter(JobWorkerValue::getEnabled).forEach(jobWorkerValue -> this.jobWorkerManager.openWorker(client, (JobWorkerValue)jobWorkerValue));
    }

    @Override
    public void stop(CamundaClient camundaClient) {
        this.jobWorkerManager.closeAllOpenWorkers();
    }
}

