/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limit.WindowedLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.FlowControlLimits;
import io.camunda.zeebe.logstreams.impl.flowcontrol.StabilizingAIMDLimit;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class LimitSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static byte[] serialize(FlowControlLimits flowControlStatus) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes((Object)flowControlStatus);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode deserialize(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        OBJECT_MAPPER.addMixIn(StabilizingAIMDLimit.class, AIMDLimitMixIn.class);
        OBJECT_MAPPER.addMixIn(WindowedLimit.class, WindowedLimitMixIn.class);
        OBJECT_MAPPER.addMixIn(VegasLimit.class, VegasLimitMixIn.class);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }

    @JsonIncludeProperties(value={"limit", "minLimit", "maxLimit", "backoffRatio", "expectedRTT"})
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static final class AIMDLimitMixIn {
        private AIMDLimitMixIn() {
        }
    }

    @JsonIncludeProperties(value={"delegate"})
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static final class WindowedLimitMixIn {
        private WindowedLimitMixIn() {
        }
    }

    @JsonIncludeProperties(value={"limit", "estimatedLimit", "rtt_noload", "maxLimit", "smoothing"})
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static final class VegasLimitMixIn {
        private VegasLimitMixIn() {
        }
    }
}

