/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryMetadata;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.List;

public final class InFlightEntry {
    final LogStreamMetrics metrics;
    List<LogAppendEntryMetadata> entryMetadata;
    Limiter.Listener requestListener;
    CloseableSilently writeTimer;
    CloseableSilently commitTimer;

    public InFlightEntry(LogStreamMetrics metrics, List<LogAppendEntryMetadata> entryMetadata, Limiter.Listener requestListener) {
        this.metrics = metrics;
        this.entryMetadata = entryMetadata;
        this.requestListener = requestListener;
        this.writeTimer = null;
        this.commitTimer = null;
    }

    public void onAppend() {
        this.writeTimer = this.metrics.startWriteTimer();
        this.commitTimer = this.metrics.startCommitTimer();
        if (this.requestListener != null) {
            this.metrics.increaseInflightRequests();
        }
    }

    public void onWrite() {
        CloseableSilently writeTimer;
        List<LogAppendEntryMetadata> entryMetadata = this.entryMetadata;
        if (entryMetadata != null) {
            entryMetadata.forEach(metadata -> this.metrics.recordAppendedEntry(1, metadata.recordType(), metadata.valueType(), metadata.intent()));
            this.entryMetadata = null;
        }
        if ((writeTimer = this.writeTimer) != null) {
            writeTimer.close();
            this.writeTimer = null;
        }
    }

    public void onCommit() {
        CloseableSilently commitTimer = this.commitTimer;
        if (commitTimer != null) {
            commitTimer.close();
            this.commitTimer = null;
        }
    }

    public void onProcessed() {
        Limiter.Listener requestListener = this.requestListener;
        if (requestListener != null) {
            requestListener.onSuccess();
            this.metrics.decreaseInflightRequests();
            this.requestListener = null;
        }
    }

    public void cleanup() {
        CloseableSilently commitTimer;
        CloseableSilently writeTimer;
        Limiter.Listener requestListener = this.requestListener;
        if (requestListener != null) {
            requestListener.onIgnore();
        }
        if ((writeTimer = this.writeTimer) != null) {
            writeTimer.close();
        }
        if ((commitTimer = this.commitTimer) != null) {
            commitTimer.close();
        }
    }
}

