/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.distribution;

import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.impl.record.value.clock.ClockRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CommandDistributionRecord
extends UnifiedRecordValue
implements CommandDistributionRecordValue {
    private static final Map<ValueType, Supplier<UnifiedRecordValue>> RECORDS_BY_TYPE = new EnumMap<ValueType, Supplier<UnifiedRecordValue>>(ValueType.class);
    private final IntegerProperty partitionIdProperty = new IntegerProperty("partitionId");
    private final StringProperty queueIdProperty = new StringProperty("queueId", "");
    private final EnumProperty<ValueType> valueTypeProperty = new EnumProperty("valueType", ValueType.class, (Enum)ValueType.NULL_VAL);
    private final IntegerProperty intentProperty = new IntegerProperty("intent", 255);
    private final ObjectProperty<UnifiedRecordValue> commandValueProperty = new ObjectProperty("commandValue", (ObjectValue)new UnifiedRecordValue(10));
    private final MsgPackWriter commandValueWriter = new MsgPackWriter();
    private final MsgPackReader commandValueReader = new MsgPackReader();

    public CommandDistributionRecord() {
        super(5);
        this.declareProperty((BaseProperty)this.partitionIdProperty).declareProperty((BaseProperty)this.queueIdProperty).declareProperty(this.valueTypeProperty).declareProperty((BaseProperty)this.intentProperty).declareProperty(this.commandValueProperty);
    }

    public CommandDistributionRecord wrap(CommandDistributionRecord other) {
        this.setPartitionId(other.getPartitionId()).setQueueId(other.getQueueId()).setValueType(other.getValueType()).setIntent(other.getIntent()).setCommandValue(other.getCommandValue());
        return this;
    }

    public int getPartitionId() {
        return this.partitionIdProperty.getValue();
    }

    public String getQueueId() {
        String value = BufferUtil.bufferAsString((DirectBuffer)this.queueIdProperty.getValue());
        return value.isEmpty() ? null : value;
    }

    public ValueType getValueType() {
        return (ValueType)this.valueTypeProperty.getValue();
    }

    public Intent getIntent() {
        int intentValue = this.intentProperty.getValue();
        if (intentValue < 0 || intentValue > Short.MAX_VALUE) {
            throw new IllegalStateException(String.format("Expected to read the intent, but it's persisted value '%d' is not a short integer", intentValue));
        }
        return Intent.fromProtocolValue((ValueType)this.getValueType(), (short)((short)intentValue));
    }

    public UnifiedRecordValue getCommandValue() {
        ValueType valueType = this.getValueType();
        if (valueType == ValueType.NULL_VAL) {
            return null;
        }
        UnifiedRecordValue storedCommandValue = (UnifiedRecordValue)this.commandValueProperty.getValue();
        if (storedCommandValue.isEmpty()) {
            return storedCommandValue;
        }
        Supplier<UnifiedRecordValue> concrecteCommandValueSupplier = RECORDS_BY_TYPE.get(valueType);
        if (concrecteCommandValueSupplier == null) {
            throw new IllegalStateException("Expected to read the record value, but it's type `" + valueType.name() + "` is unknown. Please add it to CommandDistributionRecord.RECORDS_BY_TYPE");
        }
        UnifiedRecordValue concreteCommandValue = concrecteCommandValueSupplier.get();
        UnsafeBuffer commandValueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = storedCommandValue.getEncodedLength();
        commandValueBuffer.wrap(new byte[encodedLength]);
        storedCommandValue.write(this.commandValueWriter.wrap((MutableDirectBuffer)commandValueBuffer, 0));
        concreteCommandValue.wrap((DirectBuffer)commandValueBuffer);
        return concreteCommandValue;
    }

    public CommandDistributionRecord setCommandValue(UnifiedRecordValue commandValue) {
        if (commandValue == null) {
            this.commandValueProperty.reset();
            return this;
        }
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = commandValue.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        commandValue.write((MutableDirectBuffer)valueBuffer, 0);
        ((UnifiedRecordValue)this.commandValueProperty.getValue()).read(this.commandValueReader.wrap((DirectBuffer)valueBuffer, 0, encodedLength));
        return this;
    }

    public CommandDistributionRecord setIntent(Intent intent) {
        this.intentProperty.setValue((int)intent.value());
        return this;
    }

    public CommandDistributionRecord setValueType(ValueType valueType) {
        this.valueTypeProperty.setValue((Enum)valueType);
        return this;
    }

    public CommandDistributionRecord setQueueId(String queueId) {
        if (queueId == null) {
            this.queueIdProperty.reset();
        } else {
            this.queueIdProperty.setValue(queueId);
        }
        return this;
    }

    public CommandDistributionRecord setPartitionId(int partitionId) {
        this.partitionIdProperty.setValue(partitionId);
        return this;
    }

    static {
        RECORDS_BY_TYPE.put(ValueType.DEPLOYMENT, DeploymentRecord::new);
        RECORDS_BY_TYPE.put(ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionRecord::new);
        RECORDS_BY_TYPE.put(ValueType.RESOURCE_DELETION, ResourceDeletionRecord::new);
        RECORDS_BY_TYPE.put(ValueType.SIGNAL, SignalRecord::new);
        RECORDS_BY_TYPE.put(ValueType.USER, UserRecord::new);
        RECORDS_BY_TYPE.put(ValueType.CLOCK, ClockRecord::new);
        RECORDS_BY_TYPE.put(ValueType.AUTHORIZATION, AuthorizationRecord::new);
    }
}

