/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.EngineMetricsDoc;
import io.camunda.zeebe.protocol.record.value.JobKind;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.BoundedMeterCache;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class JobProcessingMetrics {
    private final Table<EngineMetricsDoc.JobAction, JobKind, BoundedMeterCache<Counter>> jobEvents = Table.simple();
    private final MeterRegistry registry;

    public JobProcessingMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void countJobEvent(EngineMetricsDoc.JobAction action, JobKind kind, String type) {
        this.countJobEvent(action, kind, type, 1);
    }

    public void countJobEvent(EngineMetricsDoc.JobAction action, JobKind kind, String type, int amount) {
        ((Counter)((BoundedMeterCache)this.jobEvents.computeIfAbsent((Object)action, (Object)kind, this::registerJobEventCounter)).get(type)).increment((double)amount);
    }

    private BoundedMeterCache<Counter> registerJobEventCounter(EngineMetricsDoc.JobAction jobAction, JobKind kind) {
        Meter.MeterProvider provider = Counter.builder((String)EngineMetricsDoc.JOB_EVENTS.getName()).description(EngineMetricsDoc.JOB_EVENTS.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.JOB_ACTION.asString(), jobAction.getLabel()).tag(EngineMetricsDoc.EngineKeyNames.JOB_KIND.asString(), kind.name()).withRegistry(this.registry);
        return BoundedMeterCache.of((MeterRegistry)this.registry, (Meter.MeterProvider)provider, (KeyName)EngineMetricsDoc.EngineKeyNames.JOB_TYPE);
    }
}

