/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.metrics.JobProcessingMetrics;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnSignalBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnUserTaskBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.MultiInstanceOutputCollectionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.common.ElementActivationBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.job.behaviour.JobUpdateBehaviour;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.processing.variable.VariableStateEvaluationContextLookup;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.routing.RoutingInfo;
import java.time.InstantSource;
import org.camunda.feel.FeelEngineClock;

public final class BpmnBehaviorsImpl
implements BpmnBehaviors {
    private final ExpressionProcessor expressionBehavior;
    private final BpmnDecisionBehavior bpmnDecisionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final MultiInstanceOutputCollectionBehavior multiInstanceOutputCollectionBehavior;
    private final CatchEventBehavior catchEventBehavior;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableBehavior variableBehavior;
    private final ElementActivationBehavior elementActivationBehavior;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final BpmnSignalBehavior signalBehavior;
    private final BpmnUserTaskBehavior userTaskBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;
    private final JobUpdateBehaviour jobUpdateBehaviour;

    public BpmnBehaviorsImpl(MutableProcessingState processingState, Writers writers, JobProcessingMetrics jobMetrics, DecisionBehavior decisionBehavior, SubscriptionCommandSender subscriptionCommandSender, RoutingInfo routingInfo, DueDateTimerChecker timerChecker, JobStreamer jobStreamer, InstantSource clock, TransientPendingSubscriptionState transientProcessMessageSubscriptionState) {
        this.expressionBehavior = new ExpressionProcessor(ExpressionLanguageFactory.createExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(clock)), new VariableStateEvaluationContextLookup(processingState.getVariableState()));
        this.variableBehavior = new VariableBehavior(processingState.getVariableState(), writers.state(), processingState.getKeyGenerator());
        this.catchEventBehavior = new CatchEventBehavior(processingState, processingState.getKeyGenerator(), this.expressionBehavior, subscriptionCommandSender, writers.state(), writers.sideEffect(), timerChecker, routingInfo, clock, transientProcessMessageSubscriptionState);
        this.eventTriggerBehavior = new EventTriggerBehavior(processingState.getKeyGenerator(), this.catchEventBehavior, writers, processingState);
        this.stateBehavior = new BpmnStateBehavior(processingState, this.variableBehavior);
        this.bpmnDecisionBehavior = new BpmnDecisionBehavior(decisionBehavior, processingState, this.eventTriggerBehavior, writers.state(), processingState.getKeyGenerator(), this.expressionBehavior, this.stateBehavior);
        this.stateTransitionGuard = new ProcessInstanceStateTransitionGuard(this.stateBehavior);
        this.variableMappingBehavior = new BpmnVariableMappingBehavior(this.expressionBehavior, processingState, this.variableBehavior, this.eventTriggerBehavior);
        this.eventSubscriptionBehavior = new BpmnEventSubscriptionBehavior(this.catchEventBehavior, this.eventTriggerBehavior, processingState);
        this.incidentBehavior = new BpmnIncidentBehavior(processingState, processingState.getKeyGenerator(), writers.state());
        this.eventPublicationBehavior = new BpmnEventPublicationBehavior(processingState, processingState.getKeyGenerator(), this.eventTriggerBehavior, this.stateBehavior, writers);
        this.processResultSenderBehavior = new BpmnProcessResultSenderBehavior(processingState, writers.response());
        this.bufferedMessageStartEventBehavior = new BpmnBufferedMessageStartEventBehavior(processingState, processingState.getKeyGenerator(), this.eventTriggerBehavior, this.stateBehavior, writers, clock);
        this.jobActivationBehavior = new BpmnJobActivationBehavior(jobStreamer, processingState.getVariableState(), writers, processingState.getKeyGenerator(), jobMetrics, clock);
        this.multiInstanceOutputCollectionBehavior = new MultiInstanceOutputCollectionBehavior(this.stateBehavior, this.expressionBehavior());
        this.elementActivationBehavior = new ElementActivationBehavior(processingState.getKeyGenerator(), writers, this.catchEventBehavior, processingState.getElementInstanceState());
        this.signalBehavior = new BpmnSignalBehavior(processingState.getKeyGenerator(), processingState.getVariableState(), writers, this.expressionBehavior);
        this.userTaskBehavior = new BpmnUserTaskBehavior(processingState.getKeyGenerator(), writers, this.expressionBehavior, this.stateBehavior, processingState.getFormState(), processingState.getUserTaskState(), clock);
        this.jobBehavior = new BpmnJobBehavior(processingState.getKeyGenerator(), processingState.getJobState(), writers, this.expressionBehavior, this.stateBehavior, processingState.getResourceState(), this.incidentBehavior, this.jobActivationBehavior, jobMetrics, this.userTaskBehavior);
        this.compensationSubscriptionBehaviour = new BpmnCompensationSubscriptionBehaviour(processingState.getKeyGenerator(), processingState, writers, this.stateBehavior);
        this.jobUpdateBehaviour = new JobUpdateBehaviour(processingState.getJobState(), writers, clock);
    }

    @Override
    public ExpressionProcessor expressionBehavior() {
        return this.expressionBehavior;
    }

    @Override
    public BpmnDecisionBehavior bpmnDecisionBehavior() {
        return this.bpmnDecisionBehavior;
    }

    @Override
    public BpmnVariableMappingBehavior variableMappingBehavior() {
        return this.variableMappingBehavior;
    }

    @Override
    public BpmnEventPublicationBehavior eventPublicationBehavior() {
        return this.eventPublicationBehavior;
    }

    @Override
    public BpmnEventSubscriptionBehavior eventSubscriptionBehavior() {
        return this.eventSubscriptionBehavior;
    }

    @Override
    public BpmnIncidentBehavior incidentBehavior() {
        return this.incidentBehavior;
    }

    @Override
    public BpmnStateBehavior stateBehavior() {
        return this.stateBehavior;
    }

    @Override
    public ProcessInstanceStateTransitionGuard stateTransitionGuard() {
        return this.stateTransitionGuard;
    }

    @Override
    public BpmnProcessResultSenderBehavior processResultSenderBehavior() {
        return this.processResultSenderBehavior;
    }

    @Override
    public BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior() {
        return this.bufferedMessageStartEventBehavior;
    }

    @Override
    public BpmnJobBehavior jobBehavior() {
        return this.jobBehavior;
    }

    @Override
    public BpmnSignalBehavior signalBehavior() {
        return this.signalBehavior;
    }

    @Override
    public MultiInstanceOutputCollectionBehavior outputCollectionBehavior() {
        return this.multiInstanceOutputCollectionBehavior;
    }

    @Override
    public CatchEventBehavior catchEventBehavior() {
        return this.catchEventBehavior;
    }

    @Override
    public EventTriggerBehavior eventTriggerBehavior() {
        return this.eventTriggerBehavior;
    }

    @Override
    public VariableBehavior variableBehavior() {
        return this.variableBehavior;
    }

    @Override
    public ElementActivationBehavior elementActivationBehavior() {
        return this.elementActivationBehavior;
    }

    @Override
    public BpmnJobActivationBehavior jobActivationBehavior() {
        return this.jobActivationBehavior;
    }

    @Override
    public BpmnUserTaskBehavior userTaskBehavior() {
        return this.userTaskBehavior;
    }

    @Override
    public BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour() {
        return this.compensationSubscriptionBehaviour;
    }

    @Override
    public JobUpdateBehaviour jobUpdateBehaviour() {
        return this.jobUpdateBehaviour;
    }
}

