/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableInclusiveGateway;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;

public final class InclusiveGatewayProcessor
implements BpmnElementProcessor<ExecutableInclusiveGateway> {
    private static final String NO_OUTGOING_FLOW_CHOSEN_ERROR = "Expected at least one condition to evaluate to true, or to have a default flow";
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnJobBehavior jobBehavior;

    public InclusiveGatewayProcessor(BpmnBehaviors behaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.expressionBehavior = behaviors.expressionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.jobBehavior = behaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableInclusiveGateway> getType() {
        return ExecutableInclusiveGateway.class;
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableInclusiveGateway element, BpmnElementContext activating) {
        return this.findSequenceFlowsToTake(element, activating).flatMap(optFlows -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(activating, element.getEventType());
            BpmnElementContext completing = this.stateTransitionBehavior.transitionToCompleting(activated);
            return this.stateTransitionBehavior.transitionToCompleted(element, completing).thenDo(completed -> {
                if (optFlows != null) {
                    optFlows.forEach(flow -> this.stateTransitionBehavior.takeSequenceFlow((BpmnElementContext)completed, (ExecutableSequenceFlow)flow));
                }
            });
        });
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableInclusiveGateway element, BpmnElementContext context) {
        throw new UnsupportedOperationException(String.format("Expected to explicitly process complete, but gateway %s has no wait state", BufferUtil.bufferAsString((DirectBuffer)context.getElementId())));
    }

    @Override
    public void onTerminate(ExecutableInclusiveGateway element, BpmnElementContext context) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(context);
        }
        this.incidentBehavior.resolveIncidents(context);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private Either<Failure, List<ExecutableSequenceFlow>> findSequenceFlowsToTake(ExecutableInclusiveGateway element, BpmnElementContext context) {
        ArrayList<ExecutableSequenceFlow> executableSequenceFlows = new ArrayList<ExecutableSequenceFlow>();
        if (element.getOutgoing().isEmpty()) {
            return Either.right(null);
        }
        List<ExecutableSequenceFlow> outgoingSequenceFlows = element.getOutgoing();
        if (outgoingSequenceFlows.size() == 1 && outgoingSequenceFlows.getFirst().getCondition() == null) {
            executableSequenceFlows.add(outgoingSequenceFlows.getFirst());
            return Either.right(executableSequenceFlows);
        }
        for (ExecutableSequenceFlow sequenceFlow : element.getOutgoingWithCondition()) {
            if (element.getDefaultFlow() != null && element.getDefaultFlow() == sequenceFlow) continue;
            Expression condition = sequenceFlow.getCondition();
            Either<Failure, Boolean> isFulfilledOrFailure = this.expressionBehavior.evaluateBooleanExpression(condition, context.getElementInstanceKey());
            if (isFulfilledOrFailure.isLeft()) {
                return Either.left((Object)((Failure)isFulfilledOrFailure.getLeft()));
            }
            if (!((Boolean)isFulfilledOrFailure.get()).booleanValue()) continue;
            executableSequenceFlows.add(sequenceFlow);
        }
        if (executableSequenceFlows.size() > 0) {
            return Either.right(executableSequenceFlows);
        }
        if (element.getDefaultFlow() != null) {
            executableSequenceFlows.add(element.getDefaultFlow());
            return Either.right(executableSequenceFlows);
        }
        return Either.left((Object)new Failure(NO_OUTGOING_FLOW_CHOSEN_ERROR, ErrorType.CONDITION_ERROR, context.getElementInstanceKey()));
    }
}

