/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

class JobCompletedApplierV2
implements TypedEventApplier<JobIntent, JobRecord> {
    private final MutableJobState jobState;
    private final MutableElementInstanceState elementInstanceState;

    JobCompletedApplierV2(MutableProcessingState state) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
    }

    @Override
    public void applyState(long key, JobRecord value) {
        this.jobState.complete(key, value);
        long elementInstanceKey = value.getElementInstanceKey();
        ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (elementInstance != null) {
            elementInstance.setJobKey(-1L);
            this.elementInstanceState.updateInstance(elementInstance);
        }
    }
}

