/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.instance.EventScopeInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;

public final class DbEventScopeInstanceState
implements MutableEventScopeInstanceState {
    private final DbLong eventScopeKey = new DbLong();
    private final EventScopeInstance eventScopeInstance = new EventScopeInstance();
    private final ColumnFamily<DbLong, EventScopeInstance> eventScopeInstanceColumnFamily;
    private final DbLong eventTriggerScopeKey;
    private final DbLong eventTriggerEventKey;
    private final DbCompositeKey<DbLong, DbLong> eventTriggerKey;
    private final EventTrigger eventTrigger;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, EventTrigger> eventTriggerColumnFamily;

    public DbEventScopeInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.eventScopeInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EVENT_SCOPE, transactionContext, (DbKey)this.eventScopeKey, (DbValue)this.eventScopeInstance);
        this.eventTriggerScopeKey = new DbLong();
        this.eventTriggerEventKey = new DbLong();
        this.eventTriggerKey = new DbCompositeKey((DbKey)this.eventTriggerScopeKey, (DbKey)this.eventTriggerEventKey);
        this.eventTrigger = new EventTrigger();
        this.eventTriggerColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EVENT_TRIGGER, transactionContext, this.eventTriggerKey, (DbValue)this.eventTrigger);
    }

    @Override
    public void createInstance(long eventScopeKey, Collection<DirectBuffer> interruptingElementIds, Collection<DirectBuffer> boundaryElementIds) {
        this.eventScopeInstance.reset();
        this.eventScopeKey.wrapLong(eventScopeKey);
        this.eventScopeInstance.setAccepting(true);
        this.eventScopeInstance.setInterrupted(false);
        for (DirectBuffer elementId : interruptingElementIds) {
            this.eventScopeInstance.addInterruptingElementId(elementId);
        }
        for (DirectBuffer elementId : boundaryElementIds) {
            this.eventScopeInstance.addBoundaryElementId(elementId);
        }
        this.eventScopeInstanceColumnFamily.insert((DbKey)this.eventScopeKey, (DbValue)this.eventScopeInstance);
    }

    @Override
    public void deleteInstance(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> this.deleteTrigger((DbCompositeKey<DbLong, DbLong>)key));
        this.eventScopeKey.wrapLong(eventScopeKey);
        this.eventScopeInstanceColumnFamily.deleteIfExists((DbKey)this.eventScopeKey);
    }

    @Override
    public EventTrigger pollEventTrigger(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        EventTrigger[] next = new EventTrigger[1];
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            next[0] = new EventTrigger((EventTrigger)value);
            this.deleteTrigger((DbCompositeKey<DbLong, DbLong>)key);
            return false;
        });
        return next[0];
    }

    @Override
    public void triggerEvent(long eventScopeKey, long eventKey, DirectBuffer elementId, DirectBuffer variables, long processInstanceKey) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        if (this.canTriggerEvent(instance, elementId)) {
            boolean isInterruptingElementId = instance.isInterruptingElementId(elementId);
            boolean isBoundaryElementId = instance.isBoundaryElementId(elementId);
            if (isInterruptingElementId) {
                instance.setInterrupted(true);
            }
            if (isBoundaryElementId && isInterruptingElementId) {
                instance.setAccepting(false);
            }
            this.eventScopeInstanceColumnFamily.update((DbKey)this.eventScopeKey, (DbValue)instance);
            this.createTrigger(eventScopeKey, eventKey, elementId, variables, processInstanceKey);
        }
    }

    @Override
    public void triggerStartEvent(long processDefinitionKey, long eventKey, DirectBuffer elementId, DirectBuffer variables, long processInstanceKey) {
        this.createTrigger(processDefinitionKey, eventKey, elementId, variables, processInstanceKey);
    }

    @Override
    public void deleteTrigger(long eventScopeKey, long eventKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerEventKey.wrapLong(eventKey);
        this.deleteTrigger(this.eventTriggerKey);
    }

    @Override
    public EventScopeInstance getInstance(long eventScopeKey) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        return instance != null ? new EventScopeInstance(instance) : null;
    }

    @Override
    public EventTrigger peekEventTrigger(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        EventTrigger[] next = new EventTrigger[1];
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            next[0] = new EventTrigger((EventTrigger)value);
            return false;
        });
        return next[0];
    }

    @Override
    public Optional<EventTrigger> findEventTrigger(long eventScopeKey, Predicate<EventTrigger> predicate) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        AtomicReference eventTrigger = new AtomicReference();
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            if (predicate.test((EventTrigger)value)) {
                EventTrigger copiedEventTrigger = new EventTrigger();
                copiedEventTrigger.copyFrom((BufferWriter)value);
                eventTrigger.set(copiedEventTrigger);
                return false;
            }
            return true;
        });
        return Optional.ofNullable((EventTrigger)((Object)eventTrigger.get()));
    }

    @Override
    public boolean canTriggerEvent(long eventScopeKey, DirectBuffer elementId) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        return this.canTriggerEvent(instance, elementId);
    }

    private boolean canTriggerEvent(EventScopeInstance instance, DirectBuffer elementId) {
        return instance != null && instance.isAccepting() && (!instance.isInterrupted() || instance.isBoundaryElementId(elementId));
    }

    private void createTrigger(long eventScopeKey, long eventKey, DirectBuffer elementId, DirectBuffer variables, long processInstanceKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerEventKey.wrapLong(eventKey);
        this.eventTrigger.setElementId(elementId).setVariables(variables).setEventKey(eventKey).setProcessInstanceKey(processInstanceKey);
        this.eventTriggerColumnFamily.insert(this.eventTriggerKey, (DbValue)this.eventTrigger);
    }

    private void deleteTrigger(DbCompositeKey<DbLong, DbLong> triggerKey) {
        this.eventTriggerColumnFamily.deleteIfExists(triggerKey);
    }
}

