/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.adapter;

import io.dekorate.certmanager.annotation.PrivateKeyAlgorithm;
import io.dekorate.certmanager.annotation.PrivateKeyEncoding;
import io.dekorate.certmanager.annotation.RotationPolicy;
import io.dekorate.certmanager.config.CA;
import io.dekorate.certmanager.config.CABuilder;
import io.dekorate.certmanager.config.CertificateConfig;
import io.dekorate.certmanager.config.CertificateConfigBuilder;
import io.dekorate.certmanager.config.CertificateKeystore;
import io.dekorate.certmanager.config.CertificateKeystoreBuilder;
import io.dekorate.certmanager.config.CertificateKeystores;
import io.dekorate.certmanager.config.CertificateKeystoresBuilder;
import io.dekorate.certmanager.config.CertificatePrivateKey;
import io.dekorate.certmanager.config.CertificatePrivateKeyBuilder;
import io.dekorate.certmanager.config.IssuerRef;
import io.dekorate.certmanager.config.IssuerRefBuilder;
import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.LocalObjectReferenceBuilder;
import io.dekorate.certmanager.config.SelfSigned;
import io.dekorate.certmanager.config.SelfSignedBuilder;
import io.dekorate.certmanager.config.Subject;
import io.dekorate.certmanager.config.SubjectBuilder;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultAppRole;
import io.dekorate.certmanager.config.VaultAppRoleBuilder;
import io.dekorate.certmanager.config.VaultBuilder;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import io.dekorate.certmanager.config.VaultKubernetesAuthBuilder;
import io.dekorate.utils.Strings;
import java.util.Map;
import java.util.Optional;

public class CertificateConfigAdapter {
    public static CertificateConfigBuilder newBuilder(Map<String, Object> map) {
        return new CertificateConfigBuilder(CertificateConfigAdapter.getCertificateConfig(map));
    }

    private static CertificateConfig getCertificateConfig(Map<String, Object> map) {
        CertificateConfigBuilder certificate = (CertificateConfigBuilder)((CertificateConfigBuilder)new CertificateConfigBuilder().withName(CertificateConfigAdapter.getOptionalString(map, "name").orElse(null))).withSecretName(CertificateConfigAdapter.getOptionalString(map, "secretName").orElse(null));
        CertificateConfigAdapter.getOptionalMap(map, "subject").ifPresent(s -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withSubject(CertificateConfigAdapter.getSubject(s));
        });
        CertificateConfigAdapter.getOptionalString(map, "commonName").ifPresent(certificate::withCommonName);
        CertificateConfigAdapter.getOptionalString(map, "duration").ifPresent(certificate::withDuration);
        CertificateConfigAdapter.getOptionalString(map, "renewBefore").ifPresent(certificate::withRenewBefore);
        CertificateConfigAdapter.getOptionalString(map, "volumeMountPath").ifPresent(certificate::withVolumeMountPath);
        CertificateConfigAdapter.getOptionalArrayString(map, "dnsNames").ifPresent(certificate::withDnsNames);
        CertificateConfigAdapter.getOptionalArrayString(map, "ipAddresses").ifPresent(certificate::withIpAddresses);
        CertificateConfigAdapter.getOptionalArrayString(map, "uris").ifPresent(certificate::withUris);
        CertificateConfigAdapter.getOptionalArrayString(map, "emailAddresses").ifPresent(certificate::withEmailAddresses);
        CertificateConfigAdapter.getOptionalArrayString(map, "usages").ifPresent(certificate::withUsages);
        CertificateConfigAdapter.getOptionalMap(map, "keystores").ifPresent(k -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withKeystores(CertificateConfigAdapter.getCertificateKeystores(k));
        });
        certificate.withIsCA(CertificateConfigAdapter.getBoolean(map, "isCA", false));
        CertificateConfigAdapter.getOptionalMap(map, "privateKey").ifPresent(p -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withPrivateKey(CertificateConfigAdapter.getCertificatePrivateKey(p));
        });
        certificate.withEncodeUsagesInRequest(CertificateConfigAdapter.getBoolean(map, "encodeUsagesInRequest", false));
        CertificateConfigAdapter.getOptionalMap(map, "issuerRef").ifPresent(i -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withIssuerRef(CertificateConfigAdapter.getIssuerRef(i));
        });
        CertificateConfigAdapter.getOptionalMap(map, "CA").ifPresent(i -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withCa(CertificateConfigAdapter.getCaConfig(i));
        });
        CertificateConfigAdapter.getOptionalMap(map, "vault").ifPresent(i -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withVault(CertificateConfigAdapter.getVaultConfig(i));
        });
        CertificateConfigAdapter.getOptionalMap(map, "selfSigned").filter(m -> CertificateConfigAdapter.isEnabled(m)).ifPresent(i -> {
            CertificateConfigBuilder cfr_ignored_0 = (CertificateConfigBuilder)certificate.withSelfSigned(CertificateConfigAdapter.getSelfSignedConfig(i));
        });
        return certificate.build();
    }

    private static SelfSigned getSelfSignedConfig(Map<String, Object> map) {
        SelfSignedBuilder builder = new SelfSignedBuilder();
        CertificateConfigAdapter.getOptionalArrayString(map, "crlDistributionPoints").ifPresent(builder::withCrlDistributionPoints);
        return builder.build();
    }

    private static Vault getVaultConfig(Map<String, Object> map) {
        Optional<String> server = CertificateConfigAdapter.getOptionalString(map, "server");
        Optional<String> path = CertificateConfigAdapter.getOptionalString(map, "path");
        if (!server.isPresent() && !path.isPresent()) {
            return null;
        }
        VaultBuilder issuer = (VaultBuilder)((VaultBuilder)new VaultBuilder().withServer(server.get())).withPath(path.get());
        CertificateConfigAdapter.getOptionalMap(map, "authTokenSecretRef").ifPresent(a -> {
            VaultBuilder cfr_ignored_0 = (VaultBuilder)issuer.withAuthTokenSecretRef(CertificateConfigAdapter.getLocalObjectRef(a));
        });
        CertificateConfigAdapter.getOptionalMap(map, "authAppRole").ifPresent(a -> {
            VaultBuilder cfr_ignored_0 = (VaultBuilder)issuer.withAuthAppRole(CertificateConfigAdapter.getVaultAppRole(a));
        });
        CertificateConfigAdapter.getOptionalMap(map, "authKubernetes").ifPresent(a -> {
            VaultBuilder cfr_ignored_0 = (VaultBuilder)issuer.withAuthKubernetes(CertificateConfigAdapter.getVaultAuthKubernetes(a));
        });
        CertificateConfigAdapter.getOptionalString(map, "namespace").ifPresent(issuer::withNamespace);
        CertificateConfigAdapter.getOptionalString(map, "caBundle").ifPresent(issuer::withCaBundle);
        return issuer.build();
    }

    private static VaultKubernetesAuth getVaultAuthKubernetes(Map<String, Object> map) {
        VaultKubernetesAuthBuilder builder = new VaultKubernetesAuthBuilder();
        CertificateConfigAdapter.getOptionalString(map, "mountPath").ifPresent(builder::withMountPath);
        CertificateConfigAdapter.getOptionalString(map, "role").ifPresent(builder::withRole);
        CertificateConfigAdapter.getOptionalMap(map, "secretRef").ifPresent(s -> {
            VaultKubernetesAuthBuilder cfr_ignored_0 = (VaultKubernetesAuthBuilder)builder.withSecretRef(CertificateConfigAdapter.getLocalObjectRef(s));
        });
        return builder.build();
    }

    private static VaultAppRole getVaultAppRole(Map<String, Object> map) {
        VaultAppRoleBuilder builder = new VaultAppRoleBuilder();
        CertificateConfigAdapter.getOptionalString(map, "path").ifPresent(builder::withPath);
        CertificateConfigAdapter.getOptionalString(map, "roleId").ifPresent(builder::withRoleId);
        CertificateConfigAdapter.getOptionalMap(map, "secretRef").ifPresent(s -> {
            VaultAppRoleBuilder cfr_ignored_0 = (VaultAppRoleBuilder)builder.withSecretRef(CertificateConfigAdapter.getLocalObjectRef(s));
        });
        return builder.build();
    }

    private static CA getCaConfig(Map<String, Object> map) {
        Optional<String> secretName = CertificateConfigAdapter.getOptionalString(map, "secretName");
        if (!secretName.isPresent()) {
            return null;
        }
        CABuilder issuer = (CABuilder)new CABuilder().withSecretName(secretName.get());
        CertificateConfigAdapter.getOptionalArrayString(map, "crlDistributionPoints").ifPresent(issuer::withCrlDistributionPoints);
        return issuer.build();
    }

    private static CertificatePrivateKey getCertificatePrivateKey(Map<String, Object> map) {
        CertificatePrivateKeyBuilder builder = new CertificatePrivateKeyBuilder();
        CertificateConfigAdapter.getOptionalString(map, "rotationPolicy").map(RotationPolicy::valueOf).ifPresent(builder::withRotationPolicy);
        CertificateConfigAdapter.getOptionalString(map, "encoding").map(PrivateKeyEncoding::valueOf).ifPresent(builder::withEncoding);
        CertificateConfigAdapter.getOptionalString(map, "algorithm").map(PrivateKeyAlgorithm::valueOf).ifPresent(builder::withAlgorithm);
        CertificateConfigAdapter.getOptionalInteger(map, "size").ifPresent(builder::withSize);
        return builder.build();
    }

    private static CertificateKeystores getCertificateKeystores(Map<String, Object> map) {
        CertificateKeystoresBuilder builder = new CertificateKeystoresBuilder();
        CertificateConfigAdapter.getOptionalMap(map, "jks").ifPresent(c -> {
            CertificateKeystoresBuilder cfr_ignored_0 = (CertificateKeystoresBuilder)builder.withJks(CertificateConfigAdapter.getCertificateKeystore(c));
        });
        CertificateConfigAdapter.getOptionalMap(map, "pkcs12").ifPresent(c -> {
            CertificateKeystoresBuilder cfr_ignored_0 = (CertificateKeystoresBuilder)builder.withPkcs12(CertificateConfigAdapter.getCertificateKeystore(c));
        });
        return builder.build();
    }

    private static CertificateKeystore getCertificateKeystore(Map<String, Object> map) {
        CertificateKeystoreBuilder builder = (CertificateKeystoreBuilder)new CertificateKeystoreBuilder().withCreate(CertificateConfigAdapter.getBoolean(map, "create", false));
        CertificateConfigAdapter.getOptionalMap(map, "passwordSecretRef").ifPresent(p -> {
            CertificateKeystoreBuilder cfr_ignored_0 = (CertificateKeystoreBuilder)builder.withPasswordSecretRef(CertificateConfigAdapter.getLocalObjectRef(p));
        });
        return builder.build();
    }

    private static Subject getSubject(Map<String, Object> map) {
        SubjectBuilder builder = new SubjectBuilder();
        CertificateConfigAdapter.getOptionalArrayString(map, "organizations").ifPresent(builder::withOrganizations);
        CertificateConfigAdapter.getOptionalArrayString(map, "countries").ifPresent(builder::withCountries);
        CertificateConfigAdapter.getOptionalArrayString(map, "organizationalUnits").ifPresent(builder::withOrganizationalUnits);
        CertificateConfigAdapter.getOptionalArrayString(map, "localities").ifPresent(builder::withLocalities);
        CertificateConfigAdapter.getOptionalArrayString(map, "provinces").ifPresent(builder::withProvinces);
        CertificateConfigAdapter.getOptionalArrayString(map, "streetAddresses").ifPresent(builder::withStreetAddresses);
        CertificateConfigAdapter.getOptionalArrayString(map, "postalCodes").ifPresent(builder::withPostalCodes);
        CertificateConfigAdapter.getOptionalString(map, "serialNumber").ifPresent(builder::withSerialNumber);
        return builder.build();
    }

    private static IssuerRef getIssuerRef(Map<String, Object> objectMap) {
        Optional<String> name = CertificateConfigAdapter.getOptionalString(objectMap, "name");
        if (!name.isPresent()) {
            return null;
        }
        IssuerRefBuilder builder = new IssuerRefBuilder();
        builder.withName(name.get());
        CertificateConfigAdapter.getOptionalString(objectMap, "kind").ifPresent(builder::withKind);
        CertificateConfigAdapter.getOptionalString(objectMap, "group").ifPresent(builder::withGroup);
        return builder.build();
    }

    private static LocalObjectReference getLocalObjectRef(Map<String, Object> map) {
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder();
        CertificateConfigAdapter.getOptionalString(map, "key").ifPresent(builder::withKey);
        CertificateConfigAdapter.getOptionalString(map, "name").ifPresent(builder::withName);
        return builder.build();
    }

    private static Optional<Integer> getOptionalInteger(Map<String, Object> map, String key) {
        return Optional.ofNullable(CertificateConfigAdapter.get(map, key)).map(o -> (Integer)o);
    }

    private static boolean isEnabled(Map<String, Object> map) {
        return CertificateConfigAdapter.getBoolean(map, "enabled", false);
    }

    private static boolean getBoolean(Map<String, Object> map, String key, boolean defaultValue) {
        return Optional.ofNullable(CertificateConfigAdapter.get(map, key)).map(v -> {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            if (v instanceof String && Strings.isNotNullOrEmpty((String)((String)v))) {
                return Boolean.parseBoolean((String)v);
            }
            return defaultValue;
        }).orElse(defaultValue);
    }

    private static Optional<String> getOptionalString(Map<String, Object> map, String key) {
        return Optional.ofNullable(CertificateConfigAdapter.get(map, key)).map(o -> (String)o).filter(Strings::isNotNullOrEmpty);
    }

    private static Optional<Map<String, Object>> getOptionalMap(Map<String, Object> map, String key) {
        return Optional.ofNullable(CertificateConfigAdapter.get(map, key)).map(o -> (Map)o);
    }

    private static Optional<String[]> getOptionalArrayString(Map<String, Object> map, String key) {
        return Optional.ofNullable(CertificateConfigAdapter.get(map, key)).map(o -> (String[])o).filter(a -> ((String[])a).length > 0);
    }

    private static Object get(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null && key.contains("-")) {
            value = map.get(Strings.kebabToCamelCase((String)key));
        }
        if (value == null) {
            value = map.get(Strings.camelToKebabCase((String)key));
        }
        return value;
    }
}

