/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CA;
import io.dekorate.certmanager.config.CAFluent;
import io.dekorate.certmanager.config.CAFluentImpl;
import io.dekorate.certmanager.config.EditableCA;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class CABuilder
extends CAFluentImpl<CABuilder>
implements VisitableBuilder<CA, CABuilder> {
    CAFluent<?> fluent;
    Boolean validationEnabled;

    public CABuilder() {
        this(false);
    }

    public CABuilder(Boolean validationEnabled) {
        this(new CA(), validationEnabled);
    }

    public CABuilder(CAFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CABuilder(CAFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CA(), validationEnabled);
    }

    public CABuilder(CAFluent<?> fluent, CA instance) {
        this(fluent, instance, false);
    }

    public CABuilder(CAFluent<?> fluent, CA instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSecretName(instance.getSecretName());
        fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        this.validationEnabled = validationEnabled;
    }

    public CABuilder(CA instance) {
        this(instance, (Boolean)false);
    }

    public CABuilder(CA instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSecretName(instance.getSecretName());
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        this.validationEnabled = validationEnabled;
    }

    public EditableCA build() {
        EditableCA buildable = new EditableCA(this.fluent.getSecretName(), this.fluent.getCrlDistributionPoints());
        return buildable;
    }
}

