/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CA;
import io.dekorate.certmanager.config.CAFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CAFluentImpl<A extends CAFluent<A>>
extends BaseFluent<A>
implements CAFluent<A> {
    private String secretName;
    private List<String> crlDistributionPoints = new ArrayList<String>();

    public CAFluentImpl() {
    }

    public CAFluentImpl(CA instance) {
        this.withSecretName(instance.getSecretName());
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getCrlDistributionPoints() {
        int size = this.crlDistributionPoints != null ? this.crlDistributionPoints.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.crlDistributionPoints) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCrlDistributionPoints(String ... items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAFluentImpl that = (CAFluentImpl)o;
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        return !(this.crlDistributionPoints != null ? !this.crlDistributionPoints.equals(that.crlDistributionPoints) : that.crlDistributionPoints != null);
    }

    public int hashCode() {
        return Objects.hash(this.secretName, this.crlDistributionPoints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints);
        }
        sb.append("}");
        return sb.toString();
    }
}

