/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CA;
import io.dekorate.certmanager.config.CABuilder;
import io.dekorate.certmanager.config.CAFluentImpl;
import io.dekorate.certmanager.config.CertificateConfig;
import io.dekorate.certmanager.config.CertificateConfigFluent;
import io.dekorate.certmanager.config.CertificateKeystores;
import io.dekorate.certmanager.config.CertificateKeystoresBuilder;
import io.dekorate.certmanager.config.CertificateKeystoresFluentImpl;
import io.dekorate.certmanager.config.CertificatePrivateKey;
import io.dekorate.certmanager.config.CertificatePrivateKeyBuilder;
import io.dekorate.certmanager.config.CertificatePrivateKeyFluentImpl;
import io.dekorate.certmanager.config.IssuerRef;
import io.dekorate.certmanager.config.IssuerRefBuilder;
import io.dekorate.certmanager.config.IssuerRefFluentImpl;
import io.dekorate.certmanager.config.SelfSigned;
import io.dekorate.certmanager.config.SelfSignedBuilder;
import io.dekorate.certmanager.config.SelfSignedFluentImpl;
import io.dekorate.certmanager.config.Subject;
import io.dekorate.certmanager.config.SubjectBuilder;
import io.dekorate.certmanager.config.SubjectFluentImpl;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultBuilder;
import io.dekorate.certmanager.config.VaultFluentImpl;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CertificateConfigFluentImpl<A extends CertificateConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements CertificateConfigFluent<A> {
    private String name;
    private String secretName;
    private IssuerRefBuilder issuerRef;
    private CABuilder ca;
    private VaultBuilder vault;
    private SelfSignedBuilder selfSigned;
    private SubjectBuilder subject;
    private String commonName;
    private String duration;
    private String renewBefore;
    private List<String> dnsNames = new ArrayList<String>();
    private List<String> ipAddresses = new ArrayList<String>();
    private List<String> uris = new ArrayList<String>();
    private List<String> emailAddresses = new ArrayList<String>();
    private CertificateKeystoresBuilder keystores;
    private Boolean isCA;
    private List<String> usages = new ArrayList<String>();
    private CertificatePrivateKeyBuilder privateKey;
    private Boolean encodeUsagesInRequest;
    private String volumeMountPath;

    public CertificateConfigFluentImpl() {
    }

    public CertificateConfigFluentImpl(CertificateConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withName(instance.getName());
        this.withSecretName(instance.getSecretName());
        this.withIssuerRef(instance.getIssuerRef());
        this.withCa(instance.getCa());
        this.withVault(instance.getVault());
        this.withSelfSigned(instance.getSelfSigned());
        this.withSubject(instance.getSubject());
        this.withCommonName(instance.getCommonName());
        this.withDuration(instance.getDuration());
        this.withRenewBefore(instance.getRenewBefore());
        this.withDnsNames(instance.getDnsNames());
        this.withIpAddresses(instance.getIpAddresses());
        this.withUris(instance.getUris());
        this.withEmailAddresses(instance.getEmailAddresses());
        this.withKeystores(instance.getKeystores());
        this.withIsCA(instance.getIsCA());
        this.withUsages(instance.getUsages());
        this.withPrivateKey(instance.getPrivateKey());
        this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
        this.withVolumeMountPath(instance.getVolumeMountPath());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    @Deprecated
    public IssuerRef getIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public IssuerRef buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public A withIssuerRef(IssuerRef issuerRef) {
        this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new IssuerRefBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    @Override
    public A withNewIssuerRef(String name, String kind, String group) {
        return this.withIssuerRef(new IssuerRef(name, kind, group));
    }

    @Override
    public CertificateConfigFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNestedImpl();
    }

    @Override
    public CertificateConfigFluent.IssuerRefNested<A> withNewIssuerRefLike(IssuerRef item) {
        return new IssuerRefNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef());
    }

    @Override
    public CertificateConfigFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : new IssuerRefBuilder().build());
    }

    @Override
    public CertificateConfigFluent.IssuerRefNested<A> editOrNewIssuerRefLike(IssuerRef item) {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : item);
    }

    @Override
    @Deprecated
    public CA getCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public CA buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public A withCa(CA ca) {
        this._visitables.get((Object)"ca").remove(this.ca);
        if (ca != null) {
            this.ca = new CABuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove(this.ca);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCa() {
        return this.ca != null;
    }

    @Override
    public A withNewCa(String secretName, String[] crlDistributionPoints) {
        return this.withCa(new CA(secretName, crlDistributionPoints));
    }

    @Override
    public CertificateConfigFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    @Override
    public CertificateConfigFluent.CaNested<A> withNewCaLike(CA item) {
        return new CaNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.CaNested<A> editCa() {
        return this.withNewCaLike(this.getCa());
    }

    @Override
    public CertificateConfigFluent.CaNested<A> editOrNewCa() {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : new CABuilder().build());
    }

    @Override
    public CertificateConfigFluent.CaNested<A> editOrNewCaLike(CA item) {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : item);
    }

    @Override
    @Deprecated
    public Vault getVault() {
        return this.vault != null ? this.vault.build() : null;
    }

    @Override
    public Vault buildVault() {
        return this.vault != null ? this.vault.build() : null;
    }

    @Override
    public A withVault(Vault vault) {
        this._visitables.get((Object)"vault").remove(this.vault);
        if (vault != null) {
            this.vault = new VaultBuilder(vault);
            this._visitables.get((Object)"vault").add(this.vault);
        } else {
            this.vault = null;
            this._visitables.get((Object)"vault").remove(this.vault);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVault() {
        return this.vault != null;
    }

    @Override
    public CertificateConfigFluent.VaultNested<A> withNewVault() {
        return new VaultNestedImpl();
    }

    @Override
    public CertificateConfigFluent.VaultNested<A> withNewVaultLike(Vault item) {
        return new VaultNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.VaultNested<A> editVault() {
        return this.withNewVaultLike(this.getVault());
    }

    @Override
    public CertificateConfigFluent.VaultNested<A> editOrNewVault() {
        return this.withNewVaultLike(this.getVault() != null ? this.getVault() : new VaultBuilder().build());
    }

    @Override
    public CertificateConfigFluent.VaultNested<A> editOrNewVaultLike(Vault item) {
        return this.withNewVaultLike(this.getVault() != null ? this.getVault() : item);
    }

    @Override
    @Deprecated
    public SelfSigned getSelfSigned() {
        return this.selfSigned != null ? this.selfSigned.build() : null;
    }

    @Override
    public SelfSigned buildSelfSigned() {
        return this.selfSigned != null ? this.selfSigned.build() : null;
    }

    @Override
    public A withSelfSigned(SelfSigned selfSigned) {
        this._visitables.get((Object)"selfSigned").remove(this.selfSigned);
        if (selfSigned != null) {
            this.selfSigned = new SelfSignedBuilder(selfSigned);
            this._visitables.get((Object)"selfSigned").add(this.selfSigned);
        } else {
            this.selfSigned = null;
            this._visitables.get((Object)"selfSigned").remove(this.selfSigned);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelfSigned() {
        return this.selfSigned != null;
    }

    @Override
    public A withNewSelfSigned(Boolean enabled, String[] crlDistributionPoints) {
        return this.withSelfSigned(new SelfSigned(enabled, crlDistributionPoints));
    }

    @Override
    public CertificateConfigFluent.SelfSignedNested<A> withNewSelfSigned() {
        return new SelfSignedNestedImpl();
    }

    @Override
    public CertificateConfigFluent.SelfSignedNested<A> withNewSelfSignedLike(SelfSigned item) {
        return new SelfSignedNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.SelfSignedNested<A> editSelfSigned() {
        return this.withNewSelfSignedLike(this.getSelfSigned());
    }

    @Override
    public CertificateConfigFluent.SelfSignedNested<A> editOrNewSelfSigned() {
        return this.withNewSelfSignedLike(this.getSelfSigned() != null ? this.getSelfSigned() : new SelfSignedBuilder().build());
    }

    @Override
    public CertificateConfigFluent.SelfSignedNested<A> editOrNewSelfSignedLike(SelfSigned item) {
        return this.withNewSelfSignedLike(this.getSelfSigned() != null ? this.getSelfSigned() : item);
    }

    @Override
    @Deprecated
    public Subject getSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    @Override
    public Subject buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    @Override
    public A withSubject(Subject subject) {
        this._visitables.get((Object)"subject").remove(this.subject);
        if (subject != null) {
            this.subject = new SubjectBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        } else {
            this.subject = null;
            this._visitables.get((Object)"subject").remove(this.subject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubject() {
        return this.subject != null;
    }

    @Override
    public CertificateConfigFluent.SubjectNested<A> withNewSubject() {
        return new SubjectNestedImpl();
    }

    @Override
    public CertificateConfigFluent.SubjectNested<A> withNewSubjectLike(Subject item) {
        return new SubjectNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(this.getSubject());
    }

    @Override
    public CertificateConfigFluent.SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(this.getSubject() != null ? this.getSubject() : new SubjectBuilder().build());
    }

    @Override
    public CertificateConfigFluent.SubjectNested<A> editOrNewSubjectLike(Subject item) {
        return this.withNewSubjectLike(this.getSubject() != null ? this.getSubject() : item);
    }

    @Override
    public String getCommonName() {
        return this.commonName;
    }

    @Override
    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)this;
    }

    @Override
    public Boolean hasCommonName() {
        return this.commonName != null;
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(String duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public String getRenewBefore() {
        return this.renewBefore;
    }

    @Override
    public A withRenewBefore(String renewBefore) {
        this.renewBefore = renewBefore;
        return (A)this;
    }

    @Override
    public Boolean hasRenewBefore() {
        return this.renewBefore != null;
    }

    @Override
    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getDnsNames() {
        int size = this.dnsNames != null ? this.dnsNames.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.dnsNames) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToDnsNames(Integer index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsNames(Integer index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsNames(String ... items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsNames(Collection<String> items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    @Override
    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getIpAddresses() {
        int size = this.ipAddresses != null ? this.ipAddresses.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.ipAddresses) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToIpAddresses(Integer index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIpAddresses(Integer index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIpAddresses(String ... items) {
        for (String item : items) {
            if (this.ipAddresses == null) continue;
            this.ipAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIpAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.ipAddresses == null) continue;
            this.ipAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    @Override
    public A withUris(String ... uris) {
        if (this.uris != null) {
            this.uris.clear();
        }
        if (uris != null) {
            for (String item : uris) {
                this.addToUris(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getUris() {
        int size = this.uris != null ? this.uris.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.uris) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToUris(Integer index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUris(Integer index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUris(String ... items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUris(Collection<String> items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUris(String ... items) {
        for (String item : items) {
            if (this.uris == null) continue;
            this.uris.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUris(Collection<String> items) {
        for (String item : items) {
            if (this.uris == null) continue;
            this.uris.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUris() {
        return this.uris != null && !this.uris.isEmpty();
    }

    @Override
    public A withEmailAddresses(String ... emailAddresses) {
        if (this.emailAddresses != null) {
            this.emailAddresses.clear();
        }
        if (emailAddresses != null) {
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getEmailAddresses() {
        int size = this.emailAddresses != null ? this.emailAddresses.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.emailAddresses) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToEmailAddresses(Integer index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEmailAddresses(Integer index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEmailAddresses(String ... items) {
        for (String item : items) {
            if (this.emailAddresses == null) continue;
            this.emailAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEmailAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.emailAddresses == null) continue;
            this.emailAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEmailAddresses() {
        return this.emailAddresses != null && !this.emailAddresses.isEmpty();
    }

    @Override
    @Deprecated
    public CertificateKeystores getKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    @Override
    public CertificateKeystores buildKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    @Override
    public A withKeystores(CertificateKeystores keystores) {
        this._visitables.get((Object)"keystores").remove(this.keystores);
        if (keystores != null) {
            this.keystores = new CertificateKeystoresBuilder(keystores);
            this._visitables.get((Object)"keystores").add(this.keystores);
        } else {
            this.keystores = null;
            this._visitables.get((Object)"keystores").remove(this.keystores);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKeystores() {
        return this.keystores != null;
    }

    @Override
    public CertificateConfigFluent.KeystoresNested<A> withNewKeystores() {
        return new KeystoresNestedImpl();
    }

    @Override
    public CertificateConfigFluent.KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
        return new KeystoresNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.KeystoresNested<A> editKeystores() {
        return this.withNewKeystoresLike(this.getKeystores());
    }

    @Override
    public CertificateConfigFluent.KeystoresNested<A> editOrNewKeystores() {
        return this.withNewKeystoresLike(this.getKeystores() != null ? this.getKeystores() : new CertificateKeystoresBuilder().build());
    }

    @Override
    public CertificateConfigFluent.KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
        return this.withNewKeystoresLike(this.getKeystores() != null ? this.getKeystores() : item);
    }

    @Override
    public Boolean getIsCA() {
        return this.isCA;
    }

    @Override
    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)this;
    }

    @Override
    public Boolean hasIsCA() {
        return this.isCA != null;
    }

    @Override
    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getUsages() {
        int size = this.usages != null ? this.usages.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.usages) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsages(String ... items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    @Override
    @Deprecated
    public CertificatePrivateKey getPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    @Override
    public CertificatePrivateKey buildPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    @Override
    public A withPrivateKey(CertificatePrivateKey privateKey) {
        this._visitables.get((Object)"privateKey").remove(this.privateKey);
        if (privateKey != null) {
            this.privateKey = new CertificatePrivateKeyBuilder(privateKey);
            this._visitables.get((Object)"privateKey").add(this.privateKey);
        } else {
            this.privateKey = null;
            this._visitables.get((Object)"privateKey").remove(this.privateKey);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    @Override
    public CertificateConfigFluent.PrivateKeyNested<A> withNewPrivateKey() {
        return new PrivateKeyNestedImpl();
    }

    @Override
    public CertificateConfigFluent.PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
        return new PrivateKeyNestedImpl(item);
    }

    @Override
    public CertificateConfigFluent.PrivateKeyNested<A> editPrivateKey() {
        return this.withNewPrivateKeyLike(this.getPrivateKey());
    }

    @Override
    public CertificateConfigFluent.PrivateKeyNested<A> editOrNewPrivateKey() {
        return this.withNewPrivateKeyLike(this.getPrivateKey() != null ? this.getPrivateKey() : new CertificatePrivateKeyBuilder().build());
    }

    @Override
    public CertificateConfigFluent.PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
        return this.withNewPrivateKeyLike(this.getPrivateKey() != null ? this.getPrivateKey() : item);
    }

    @Override
    public Boolean getEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest;
    }

    @Override
    public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
        this.encodeUsagesInRequest = encodeUsagesInRequest;
        return (A)this;
    }

    @Override
    public Boolean hasEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest != null;
    }

    @Override
    public String getVolumeMountPath() {
        return this.volumeMountPath;
    }

    @Override
    public A withVolumeMountPath(String volumeMountPath) {
        this.volumeMountPath = volumeMountPath;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMountPath() {
        return this.volumeMountPath != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateConfigFluentImpl that = (CertificateConfigFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        if (this.issuerRef != null ? !this.issuerRef.equals(that.issuerRef) : that.issuerRef != null) {
            return false;
        }
        if (this.ca != null ? !this.ca.equals(that.ca) : that.ca != null) {
            return false;
        }
        if (this.vault != null ? !this.vault.equals(that.vault) : that.vault != null) {
            return false;
        }
        if (this.selfSigned != null ? !this.selfSigned.equals(that.selfSigned) : that.selfSigned != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) {
            return false;
        }
        if (this.commonName != null ? !this.commonName.equals(that.commonName) : that.commonName != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.renewBefore != null ? !this.renewBefore.equals(that.renewBefore) : that.renewBefore != null) {
            return false;
        }
        if (this.dnsNames != null ? !this.dnsNames.equals(that.dnsNames) : that.dnsNames != null) {
            return false;
        }
        if (this.ipAddresses != null ? !this.ipAddresses.equals(that.ipAddresses) : that.ipAddresses != null) {
            return false;
        }
        if (this.uris != null ? !this.uris.equals(that.uris) : that.uris != null) {
            return false;
        }
        if (this.emailAddresses != null ? !this.emailAddresses.equals(that.emailAddresses) : that.emailAddresses != null) {
            return false;
        }
        if (this.keystores != null ? !this.keystores.equals(that.keystores) : that.keystores != null) {
            return false;
        }
        if (this.isCA != null ? !this.isCA.equals(that.isCA) : that.isCA != null) {
            return false;
        }
        if (this.usages != null ? !this.usages.equals(that.usages) : that.usages != null) {
            return false;
        }
        if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) {
            return false;
        }
        if (this.encodeUsagesInRequest != null ? !this.encodeUsagesInRequest.equals(that.encodeUsagesInRequest) : that.encodeUsagesInRequest != null) {
            return false;
        }
        return !(this.volumeMountPath != null ? !this.volumeMountPath.equals(that.volumeMountPath) : that.volumeMountPath != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.secretName, this.issuerRef, this.ca, this.vault, this.selfSigned, this.subject, this.commonName, this.duration, this.renewBefore, this.dnsNames, this.ipAddresses, this.uris, this.emailAddresses, this.keystores, this.isCA, this.usages, this.privateKey, this.encodeUsagesInRequest, this.volumeMountPath, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append(this.issuerRef + ",");
        }
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.vault != null) {
            sb.append("vault:");
            sb.append(this.vault + ",");
        }
        if (this.selfSigned != null) {
            sb.append("selfSigned:");
            sb.append(this.selfSigned + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append(this.subject + ",");
        }
        if (this.commonName != null) {
            sb.append("commonName:");
            sb.append(this.commonName + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.renewBefore != null) {
            sb.append("renewBefore:");
            sb.append(this.renewBefore + ",");
        }
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.ipAddresses != null && !this.ipAddresses.isEmpty()) {
            sb.append("ipAddresses:");
            sb.append(this.ipAddresses + ",");
        }
        if (this.uris != null && !this.uris.isEmpty()) {
            sb.append("uris:");
            sb.append(this.uris + ",");
        }
        if (this.emailAddresses != null && !this.emailAddresses.isEmpty()) {
            sb.append("emailAddresses:");
            sb.append(this.emailAddresses + ",");
        }
        if (this.keystores != null) {
            sb.append("keystores:");
            sb.append(this.keystores + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.privateKey != null) {
            sb.append("privateKey:");
            sb.append(this.privateKey + ",");
        }
        if (this.encodeUsagesInRequest != null) {
            sb.append("encodeUsagesInRequest:");
            sb.append(this.encodeUsagesInRequest + ",");
        }
        if (this.volumeMountPath != null) {
            sb.append("volumeMountPath:");
            sb.append(this.volumeMountPath);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withIsCA() {
        return this.withIsCA(true);
    }

    @Override
    public A withEncodeUsagesInRequest() {
        return this.withEncodeUsagesInRequest(true);
    }

    class PrivateKeyNestedImpl<N>
    extends CertificatePrivateKeyFluentImpl<CertificateConfigFluent.PrivateKeyNested<N>>
    implements CertificateConfigFluent.PrivateKeyNested<N>,
    Nested<N> {
        CertificatePrivateKeyBuilder builder;

        PrivateKeyNestedImpl(CertificatePrivateKey item) {
            this.builder = new CertificatePrivateKeyBuilder(this, item);
        }

        PrivateKeyNestedImpl() {
            this.builder = new CertificatePrivateKeyBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withPrivateKey(this.builder.build());
        }

        @Override
        public N endPrivateKey() {
            return this.and();
        }
    }

    class KeystoresNestedImpl<N>
    extends CertificateKeystoresFluentImpl<CertificateConfigFluent.KeystoresNested<N>>
    implements CertificateConfigFluent.KeystoresNested<N>,
    Nested<N> {
        CertificateKeystoresBuilder builder;

        KeystoresNestedImpl(CertificateKeystores item) {
            this.builder = new CertificateKeystoresBuilder(this, item);
        }

        KeystoresNestedImpl() {
            this.builder = new CertificateKeystoresBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withKeystores(this.builder.build());
        }

        @Override
        public N endKeystores() {
            return this.and();
        }
    }

    class SubjectNestedImpl<N>
    extends SubjectFluentImpl<CertificateConfigFluent.SubjectNested<N>>
    implements CertificateConfigFluent.SubjectNested<N>,
    Nested<N> {
        SubjectBuilder builder;

        SubjectNestedImpl(Subject item) {
            this.builder = new SubjectBuilder(this, item);
        }

        SubjectNestedImpl() {
            this.builder = new SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withSubject(this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    class SelfSignedNestedImpl<N>
    extends SelfSignedFluentImpl<CertificateConfigFluent.SelfSignedNested<N>>
    implements CertificateConfigFluent.SelfSignedNested<N>,
    Nested<N> {
        SelfSignedBuilder builder;

        SelfSignedNestedImpl(SelfSigned item) {
            this.builder = new SelfSignedBuilder(this, item);
        }

        SelfSignedNestedImpl() {
            this.builder = new SelfSignedBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withSelfSigned(this.builder.build());
        }

        @Override
        public N endSelfSigned() {
            return this.and();
        }
    }

    class VaultNestedImpl<N>
    extends VaultFluentImpl<CertificateConfigFluent.VaultNested<N>>
    implements CertificateConfigFluent.VaultNested<N>,
    Nested<N> {
        VaultBuilder builder;

        VaultNestedImpl(Vault item) {
            this.builder = new VaultBuilder(this, item);
        }

        VaultNestedImpl() {
            this.builder = new VaultBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withVault(this.builder.build());
        }

        @Override
        public N endVault() {
            return this.and();
        }
    }

    class CaNestedImpl<N>
    extends CAFluentImpl<CertificateConfigFluent.CaNested<N>>
    implements CertificateConfigFluent.CaNested<N>,
    Nested<N> {
        CABuilder builder;

        CaNestedImpl(CA item) {
            this.builder = new CABuilder(this, item);
        }

        CaNestedImpl() {
            this.builder = new CABuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withCa(this.builder.build());
        }

        @Override
        public N endCa() {
            return this.and();
        }
    }

    class IssuerRefNestedImpl<N>
    extends IssuerRefFluentImpl<CertificateConfigFluent.IssuerRefNested<N>>
    implements CertificateConfigFluent.IssuerRefNested<N>,
    Nested<N> {
        IssuerRefBuilder builder;

        IssuerRefNestedImpl(IssuerRef item) {
            this.builder = new IssuerRefBuilder(this, item);
        }

        IssuerRefNestedImpl() {
            this.builder = new IssuerRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateConfigFluentImpl.this.withIssuerRef(this.builder.build());
        }

        @Override
        public N endIssuerRef() {
            return this.and();
        }
    }
}

