/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.SelfSigned;
import io.dekorate.certmanager.config.SelfSignedFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SelfSignedFluentImpl<A extends SelfSignedFluent<A>>
extends BaseFluent<A>
implements SelfSignedFluent<A> {
    private Boolean enabled;
    private List<String> crlDistributionPoints = new ArrayList<String>();

    public SelfSignedFluentImpl() {
    }

    public SelfSignedFluentImpl(SelfSigned instance) {
        this.withEnabled(instance.getEnabled());
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)this;
    }

    @Override
    public Boolean hasEnabled() {
        return this.enabled != null;
    }

    @Override
    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getCrlDistributionPoints() {
        int size = this.crlDistributionPoints != null ? this.crlDistributionPoints.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.crlDistributionPoints) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCrlDistributionPoints(String ... items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelfSignedFluentImpl that = (SelfSignedFluentImpl)o;
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        return !(this.crlDistributionPoints != null ? !this.crlDistributionPoints.equals(that.crlDistributionPoints) : that.crlDistributionPoints != null);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.crlDistributionPoints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withEnabled() {
        return this.withEnabled(true);
    }
}

