/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.Subject;
import io.dekorate.certmanager.config.SubjectFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SubjectFluentImpl<A extends SubjectFluent<A>>
extends BaseFluent<A>
implements SubjectFluent<A> {
    private List<String> organizations = new ArrayList<String>();
    private List<String> countries = new ArrayList<String>();
    private List<String> organizationalUnits = new ArrayList<String>();
    private List<String> localities = new ArrayList<String>();
    private List<String> provinces = new ArrayList<String>();
    private List<String> streetAddresses = new ArrayList<String>();
    private List<String> postalCodes = new ArrayList<String>();
    private String serialNumber;

    public SubjectFluentImpl() {
    }

    public SubjectFluentImpl(Subject instance) {
        this.withOrganizations(instance.getOrganizations());
        this.withCountries(instance.getCountries());
        this.withOrganizationalUnits(instance.getOrganizationalUnits());
        this.withLocalities(instance.getLocalities());
        this.withProvinces(instance.getProvinces());
        this.withStreetAddresses(instance.getStreetAddresses());
        this.withPostalCodes(instance.getPostalCodes());
        this.withSerialNumber(instance.getSerialNumber());
    }

    @Override
    public A withOrganizations(String ... organizations) {
        if (this.organizations != null) {
            this.organizations.clear();
        }
        if (organizations != null) {
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getOrganizations() {
        int size = this.organizations != null ? this.organizations.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.organizations) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToOrganizations(Integer index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOrganizations(Integer index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOrganizations(String ... items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOrganizations(String ... items) {
        for (String item : items) {
            if (this.organizations == null) continue;
            this.organizations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOrganizations(Collection<String> items) {
        for (String item : items) {
            if (this.organizations == null) continue;
            this.organizations.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOrganizations() {
        return this.organizations != null && !this.organizations.isEmpty();
    }

    @Override
    public A withCountries(String ... countries) {
        if (this.countries != null) {
            this.countries.clear();
        }
        if (countries != null) {
            for (String item : countries) {
                this.addToCountries(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getCountries() {
        int size = this.countries != null ? this.countries.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.countries) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCountries(Integer index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCountries(Integer index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCountries(String ... items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCountries(Collection<String> items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCountries(String ... items) {
        for (String item : items) {
            if (this.countries == null) continue;
            this.countries.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCountries(Collection<String> items) {
        for (String item : items) {
            if (this.countries == null) continue;
            this.countries.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCountries() {
        return this.countries != null && !this.countries.isEmpty();
    }

    @Override
    public A withOrganizationalUnits(String ... organizationalUnits) {
        if (this.organizationalUnits != null) {
            this.organizationalUnits.clear();
        }
        if (organizationalUnits != null) {
            for (String item : organizationalUnits) {
                this.addToOrganizationalUnits(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getOrganizationalUnits() {
        int size = this.organizationalUnits != null ? this.organizationalUnits.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.organizationalUnits) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToOrganizationalUnits(Integer index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOrganizationalUnits(Integer index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOrganizationalUnits(String ... items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOrganizationalUnits(Collection<String> items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOrganizationalUnits(String ... items) {
        for (String item : items) {
            if (this.organizationalUnits == null) continue;
            this.organizationalUnits.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOrganizationalUnits(Collection<String> items) {
        for (String item : items) {
            if (this.organizationalUnits == null) continue;
            this.organizationalUnits.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !this.organizationalUnits.isEmpty();
    }

    @Override
    public A withLocalities(String ... localities) {
        if (this.localities != null) {
            this.localities.clear();
        }
        if (localities != null) {
            for (String item : localities) {
                this.addToLocalities(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getLocalities() {
        int size = this.localities != null ? this.localities.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.localities) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToLocalities(Integer index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLocalities(Integer index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLocalities(String ... items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLocalities(Collection<String> items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLocalities(String ... items) {
        for (String item : items) {
            if (this.localities == null) continue;
            this.localities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLocalities(Collection<String> items) {
        for (String item : items) {
            if (this.localities == null) continue;
            this.localities.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLocalities() {
        return this.localities != null && !this.localities.isEmpty();
    }

    @Override
    public A withProvinces(String ... provinces) {
        if (this.provinces != null) {
            this.provinces.clear();
        }
        if (provinces != null) {
            for (String item : provinces) {
                this.addToProvinces(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getProvinces() {
        int size = this.provinces != null ? this.provinces.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.provinces) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToProvinces(Integer index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToProvinces(Integer index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToProvinces(String ... items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToProvinces(Collection<String> items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromProvinces(String ... items) {
        for (String item : items) {
            if (this.provinces == null) continue;
            this.provinces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromProvinces(Collection<String> items) {
        for (String item : items) {
            if (this.provinces == null) continue;
            this.provinces.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProvinces() {
        return this.provinces != null && !this.provinces.isEmpty();
    }

    @Override
    public A withStreetAddresses(String ... streetAddresses) {
        if (this.streetAddresses != null) {
            this.streetAddresses.clear();
        }
        if (streetAddresses != null) {
            for (String item : streetAddresses) {
                this.addToStreetAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getStreetAddresses() {
        int size = this.streetAddresses != null ? this.streetAddresses.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.streetAddresses) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToStreetAddresses(Integer index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToStreetAddresses(Integer index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToStreetAddresses(String ... items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToStreetAddresses(Collection<String> items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromStreetAddresses(String ... items) {
        for (String item : items) {
            if (this.streetAddresses == null) continue;
            this.streetAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStreetAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.streetAddresses == null) continue;
            this.streetAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStreetAddresses() {
        return this.streetAddresses != null && !this.streetAddresses.isEmpty();
    }

    @Override
    public A withPostalCodes(String ... postalCodes) {
        if (this.postalCodes != null) {
            this.postalCodes.clear();
        }
        if (postalCodes != null) {
            for (String item : postalCodes) {
                this.addToPostalCodes(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getPostalCodes() {
        int size = this.postalCodes != null ? this.postalCodes.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.postalCodes) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToPostalCodes(Integer index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPostalCodes(Integer index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPostalCodes(String ... items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPostalCodes(Collection<String> items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPostalCodes(String ... items) {
        for (String item : items) {
            if (this.postalCodes == null) continue;
            this.postalCodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPostalCodes(Collection<String> items) {
        for (String item : items) {
            if (this.postalCodes == null) continue;
            this.postalCodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPostalCodes() {
        return this.postalCodes != null && !this.postalCodes.isEmpty();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public A withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return (A)this;
    }

    @Override
    public Boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectFluentImpl that = (SubjectFluentImpl)o;
        if (this.organizations != null ? !this.organizations.equals(that.organizations) : that.organizations != null) {
            return false;
        }
        if (this.countries != null ? !this.countries.equals(that.countries) : that.countries != null) {
            return false;
        }
        if (this.organizationalUnits != null ? !this.organizationalUnits.equals(that.organizationalUnits) : that.organizationalUnits != null) {
            return false;
        }
        if (this.localities != null ? !this.localities.equals(that.localities) : that.localities != null) {
            return false;
        }
        if (this.provinces != null ? !this.provinces.equals(that.provinces) : that.provinces != null) {
            return false;
        }
        if (this.streetAddresses != null ? !this.streetAddresses.equals(that.streetAddresses) : that.streetAddresses != null) {
            return false;
        }
        if (this.postalCodes != null ? !this.postalCodes.equals(that.postalCodes) : that.postalCodes != null) {
            return false;
        }
        return !(this.serialNumber != null ? !this.serialNumber.equals(that.serialNumber) : that.serialNumber != null);
    }

    public int hashCode() {
        return Objects.hash(this.organizations, this.countries, this.organizationalUnits, this.localities, this.provinces, this.streetAddresses, this.postalCodes, this.serialNumber, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.organizations != null && !this.organizations.isEmpty()) {
            sb.append("organizations:");
            sb.append(this.organizations + ",");
        }
        if (this.countries != null && !this.countries.isEmpty()) {
            sb.append("countries:");
            sb.append(this.countries + ",");
        }
        if (this.organizationalUnits != null && !this.organizationalUnits.isEmpty()) {
            sb.append("organizationalUnits:");
            sb.append(this.organizationalUnits + ",");
        }
        if (this.localities != null && !this.localities.isEmpty()) {
            sb.append("localities:");
            sb.append(this.localities + ",");
        }
        if (this.provinces != null && !this.provinces.isEmpty()) {
            sb.append("provinces:");
            sb.append(this.provinces + ",");
        }
        if (this.streetAddresses != null && !this.streetAddresses.isEmpty()) {
            sb.append("streetAddresses:");
            sb.append(this.streetAddresses + ",");
        }
        if (this.postalCodes != null && !this.postalCodes.isEmpty()) {
            sb.append("postalCodes:");
            sb.append(this.postalCodes + ",");
        }
        if (this.serialNumber != null) {
            sb.append("serialNumber:");
            sb.append(this.serialNumber);
        }
        sb.append("}");
        return sb.toString();
    }
}

