/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.VaultAppRole;
import io.dekorate.certmanager.config.VaultBuilder;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import java.util.Objects;

public class Vault {
    private String server;
    private String path;
    private LocalObjectReference authTokenSecretRef;
    private VaultAppRole authAppRole;
    private VaultKubernetesAuth authKubernetes;
    private String namespace;
    private String caBundle;

    public Vault() {
    }

    public Vault(String server, String path, LocalObjectReference authTokenSecretRef, VaultAppRole authAppRole, VaultKubernetesAuth authKubernetes, String namespace, String caBundle) {
        this.server = server;
        this.path = path;
        this.authTokenSecretRef = authTokenSecretRef;
        this.authAppRole = authAppRole;
        this.authKubernetes = authKubernetes;
        this.namespace = namespace;
        this.caBundle = caBundle;
    }

    public String getServer() {
        return this.server;
    }

    public String getPath() {
        return this.path;
    }

    public LocalObjectReference getAuthTokenSecretRef() {
        return this.authTokenSecretRef;
    }

    public VaultAppRole getAuthAppRole() {
        return this.authAppRole;
    }

    public VaultKubernetesAuth getAuthKubernetes() {
        return this.authKubernetes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public static VaultBuilder newBuilder() {
        return new VaultBuilder();
    }

    public static VaultBuilder newBuilderFromDefaults() {
        return (VaultBuilder)((VaultBuilder)new VaultBuilder().withAuthAppRole(new VaultAppRole())).withAuthKubernetes(new VaultKubernetesAuth());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vault that = (Vault)o;
        if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.authTokenSecretRef != null ? !this.authTokenSecretRef.equals(that.authTokenSecretRef) : that.authTokenSecretRef != null) {
            return false;
        }
        if (this.authAppRole != null ? !this.authAppRole.equals(that.authAppRole) : that.authAppRole != null) {
            return false;
        }
        if (this.authKubernetes != null ? !this.authKubernetes.equals(that.authKubernetes) : that.authKubernetes != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.path, this.authTokenSecretRef, this.authAppRole, this.authKubernetes, this.namespace, this.caBundle, super.hashCode());
    }
}

