/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.LocalObjectReferenceBuilder;
import io.dekorate.certmanager.config.LocalObjectReferenceFluentImpl;
import io.dekorate.certmanager.config.VaultAppRole;
import io.dekorate.certmanager.config.VaultAppRoleFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class VaultAppRoleFluentImpl<A extends VaultAppRoleFluent<A>>
extends BaseFluent<A>
implements VaultAppRoleFluent<A> {
    private String path;
    private String roleId;
    private LocalObjectReferenceBuilder secretRef;

    public VaultAppRoleFluentImpl() {
    }

    public VaultAppRoleFluentImpl(VaultAppRole instance) {
        this.withPath(instance.getPath());
        this.withRoleId(instance.getRoleId());
        this.withSecretRef(instance.getSecretRef());
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public A withRoleId(String roleId) {
        this.roleId = roleId;
        return (A)this;
    }

    @Override
    public Boolean hasRoleId() {
        return this.roleId != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get((Object)"secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String key) {
        return this.withSecretRef(new LocalObjectReference(name, key));
    }

    @Override
    public VaultAppRoleFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public VaultAppRoleFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public VaultAppRoleFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public VaultAppRoleFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public VaultAppRoleFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultAppRoleFluentImpl that = (VaultAppRoleFluentImpl)o;
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.roleId != null ? !this.roleId.equals(that.roleId) : that.roleId != null) {
            return false;
        }
        return !(this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.roleId, this.secretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.roleId != null) {
            sb.append("roleId:");
            sb.append(this.roleId + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<VaultAppRoleFluent.SecretRefNested<N>>
    implements VaultAppRoleFluent.SecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultAppRoleFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

