/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.EditableVault;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultFluent;
import io.dekorate.certmanager.config.VaultFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class VaultBuilder
extends VaultFluentImpl<VaultBuilder>
implements VisitableBuilder<Vault, VaultBuilder> {
    VaultFluent<?> fluent;
    Boolean validationEnabled;

    public VaultBuilder() {
        this(false);
    }

    public VaultBuilder(Boolean validationEnabled) {
        this(new Vault(), validationEnabled);
    }

    public VaultBuilder(VaultFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public VaultBuilder(VaultFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Vault(), validationEnabled);
    }

    public VaultBuilder(VaultFluent<?> fluent, Vault instance) {
        this(fluent, instance, false);
    }

    public VaultBuilder(VaultFluent<?> fluent, Vault instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withServer(instance.getServer());
        fluent.withPath(instance.getPath());
        fluent.withAuthTokenSecretRef(instance.getAuthTokenSecretRef());
        fluent.withAuthAppRole(instance.getAuthAppRole());
        fluent.withAuthKubernetes(instance.getAuthKubernetes());
        fluent.withNamespace(instance.getNamespace());
        fluent.withCaBundle(instance.getCaBundle());
        this.validationEnabled = validationEnabled;
    }

    public VaultBuilder(Vault instance) {
        this(instance, (Boolean)false);
    }

    public VaultBuilder(Vault instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withServer(instance.getServer());
        this.withPath(instance.getPath());
        this.withAuthTokenSecretRef(instance.getAuthTokenSecretRef());
        this.withAuthAppRole(instance.getAuthAppRole());
        this.withAuthKubernetes(instance.getAuthKubernetes());
        this.withNamespace(instance.getNamespace());
        this.withCaBundle(instance.getCaBundle());
        this.validationEnabled = validationEnabled;
    }

    public EditableVault build() {
        EditableVault buildable = new EditableVault(this.fluent.getServer(), this.fluent.getPath(), this.fluent.getAuthTokenSecretRef(), this.fluent.getAuthAppRole(), this.fluent.getAuthKubernetes(), this.fluent.getNamespace(), this.fluent.getCaBundle());
        return buildable;
    }
}

