/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.LocalObjectReferenceBuilder;
import io.dekorate.certmanager.config.LocalObjectReferenceFluentImpl;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultAppRole;
import io.dekorate.certmanager.config.VaultAppRoleBuilder;
import io.dekorate.certmanager.config.VaultAppRoleFluentImpl;
import io.dekorate.certmanager.config.VaultFluent;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import io.dekorate.certmanager.config.VaultKubernetesAuthBuilder;
import io.dekorate.certmanager.config.VaultKubernetesAuthFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class VaultFluentImpl<A extends VaultFluent<A>>
extends BaseFluent<A>
implements VaultFluent<A> {
    private String server;
    private String path;
    private LocalObjectReferenceBuilder authTokenSecretRef;
    private VaultAppRoleBuilder authAppRole;
    private VaultKubernetesAuthBuilder authKubernetes;
    private String namespace;
    private String caBundle;

    public VaultFluentImpl() {
    }

    public VaultFluentImpl(Vault instance) {
        this.withServer(instance.getServer());
        this.withPath(instance.getPath());
        this.withAuthTokenSecretRef(instance.getAuthTokenSecretRef());
        this.withAuthAppRole(instance.getAuthAppRole());
        this.withAuthKubernetes(instance.getAuthKubernetes());
        this.withNamespace(instance.getNamespace());
        this.withCaBundle(instance.getCaBundle());
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    @Override
    public Boolean hasServer() {
        return this.server != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getAuthTokenSecretRef() {
        return this.authTokenSecretRef != null ? this.authTokenSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildAuthTokenSecretRef() {
        return this.authTokenSecretRef != null ? this.authTokenSecretRef.build() : null;
    }

    @Override
    public A withAuthTokenSecretRef(LocalObjectReference authTokenSecretRef) {
        this._visitables.get((Object)"authTokenSecretRef").remove(this.authTokenSecretRef);
        if (authTokenSecretRef != null) {
            this.authTokenSecretRef = new LocalObjectReferenceBuilder(authTokenSecretRef);
            this._visitables.get((Object)"authTokenSecretRef").add(this.authTokenSecretRef);
        } else {
            this.authTokenSecretRef = null;
            this._visitables.get((Object)"authTokenSecretRef").remove(this.authTokenSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthTokenSecretRef() {
        return this.authTokenSecretRef != null;
    }

    @Override
    public A withNewAuthTokenSecretRef(String name, String key) {
        return this.withAuthTokenSecretRef(new LocalObjectReference(name, key));
    }

    @Override
    public VaultFluent.AuthTokenSecretRefNested<A> withNewAuthTokenSecretRef() {
        return new AuthTokenSecretRefNestedImpl();
    }

    @Override
    public VaultFluent.AuthTokenSecretRefNested<A> withNewAuthTokenSecretRefLike(LocalObjectReference item) {
        return new AuthTokenSecretRefNestedImpl(item);
    }

    @Override
    public VaultFluent.AuthTokenSecretRefNested<A> editAuthTokenSecretRef() {
        return this.withNewAuthTokenSecretRefLike(this.getAuthTokenSecretRef());
    }

    @Override
    public VaultFluent.AuthTokenSecretRefNested<A> editOrNewAuthTokenSecretRef() {
        return this.withNewAuthTokenSecretRefLike(this.getAuthTokenSecretRef() != null ? this.getAuthTokenSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public VaultFluent.AuthTokenSecretRefNested<A> editOrNewAuthTokenSecretRefLike(LocalObjectReference item) {
        return this.withNewAuthTokenSecretRefLike(this.getAuthTokenSecretRef() != null ? this.getAuthTokenSecretRef() : item);
    }

    @Override
    @Deprecated
    public VaultAppRole getAuthAppRole() {
        return this.authAppRole != null ? this.authAppRole.build() : null;
    }

    @Override
    public VaultAppRole buildAuthAppRole() {
        return this.authAppRole != null ? this.authAppRole.build() : null;
    }

    @Override
    public A withAuthAppRole(VaultAppRole authAppRole) {
        this._visitables.get((Object)"authAppRole").remove(this.authAppRole);
        if (authAppRole != null) {
            this.authAppRole = new VaultAppRoleBuilder(authAppRole);
            this._visitables.get((Object)"authAppRole").add(this.authAppRole);
        } else {
            this.authAppRole = null;
            this._visitables.get((Object)"authAppRole").remove(this.authAppRole);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthAppRole() {
        return this.authAppRole != null;
    }

    @Override
    public VaultFluent.AuthAppRoleNested<A> withNewAuthAppRole() {
        return new AuthAppRoleNestedImpl();
    }

    @Override
    public VaultFluent.AuthAppRoleNested<A> withNewAuthAppRoleLike(VaultAppRole item) {
        return new AuthAppRoleNestedImpl(item);
    }

    @Override
    public VaultFluent.AuthAppRoleNested<A> editAuthAppRole() {
        return this.withNewAuthAppRoleLike(this.getAuthAppRole());
    }

    @Override
    public VaultFluent.AuthAppRoleNested<A> editOrNewAuthAppRole() {
        return this.withNewAuthAppRoleLike(this.getAuthAppRole() != null ? this.getAuthAppRole() : new VaultAppRoleBuilder().build());
    }

    @Override
    public VaultFluent.AuthAppRoleNested<A> editOrNewAuthAppRoleLike(VaultAppRole item) {
        return this.withNewAuthAppRoleLike(this.getAuthAppRole() != null ? this.getAuthAppRole() : item);
    }

    @Override
    @Deprecated
    public VaultKubernetesAuth getAuthKubernetes() {
        return this.authKubernetes != null ? this.authKubernetes.build() : null;
    }

    @Override
    public VaultKubernetesAuth buildAuthKubernetes() {
        return this.authKubernetes != null ? this.authKubernetes.build() : null;
    }

    @Override
    public A withAuthKubernetes(VaultKubernetesAuth authKubernetes) {
        this._visitables.get((Object)"authKubernetes").remove(this.authKubernetes);
        if (authKubernetes != null) {
            this.authKubernetes = new VaultKubernetesAuthBuilder(authKubernetes);
            this._visitables.get((Object)"authKubernetes").add(this.authKubernetes);
        } else {
            this.authKubernetes = null;
            this._visitables.get((Object)"authKubernetes").remove(this.authKubernetes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthKubernetes() {
        return this.authKubernetes != null;
    }

    @Override
    public VaultFluent.AuthKubernetesNested<A> withNewAuthKubernetes() {
        return new AuthKubernetesNestedImpl();
    }

    @Override
    public VaultFluent.AuthKubernetesNested<A> withNewAuthKubernetesLike(VaultKubernetesAuth item) {
        return new AuthKubernetesNestedImpl(item);
    }

    @Override
    public VaultFluent.AuthKubernetesNested<A> editAuthKubernetes() {
        return this.withNewAuthKubernetesLike(this.getAuthKubernetes());
    }

    @Override
    public VaultFluent.AuthKubernetesNested<A> editOrNewAuthKubernetes() {
        return this.withNewAuthKubernetesLike(this.getAuthKubernetes() != null ? this.getAuthKubernetes() : new VaultKubernetesAuthBuilder().build());
    }

    @Override
    public VaultFluent.AuthKubernetesNested<A> editOrNewAuthKubernetesLike(VaultKubernetesAuth item) {
        return this.withNewAuthKubernetesLike(this.getAuthKubernetes() != null ? this.getAuthKubernetes() : item);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public String getCaBundle() {
        return this.caBundle;
    }

    @Override
    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultFluentImpl that = (VaultFluentImpl)o;
        if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.authTokenSecretRef != null ? !this.authTokenSecretRef.equals(that.authTokenSecretRef) : that.authTokenSecretRef != null) {
            return false;
        }
        if (this.authAppRole != null ? !this.authAppRole.equals(that.authAppRole) : that.authAppRole != null) {
            return false;
        }
        if (this.authKubernetes != null ? !this.authKubernetes.equals(that.authKubernetes) : that.authKubernetes != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.path, this.authTokenSecretRef, this.authAppRole, this.authKubernetes, this.namespace, this.caBundle, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.authTokenSecretRef != null) {
            sb.append("authTokenSecretRef:");
            sb.append(this.authTokenSecretRef + ",");
        }
        if (this.authAppRole != null) {
            sb.append("authAppRole:");
            sb.append(this.authAppRole + ",");
        }
        if (this.authKubernetes != null) {
            sb.append("authKubernetes:");
            sb.append(this.authKubernetes + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle);
        }
        sb.append("}");
        return sb.toString();
    }

    class AuthKubernetesNestedImpl<N>
    extends VaultKubernetesAuthFluentImpl<VaultFluent.AuthKubernetesNested<N>>
    implements VaultFluent.AuthKubernetesNested<N>,
    Nested<N> {
        VaultKubernetesAuthBuilder builder;

        AuthKubernetesNestedImpl(VaultKubernetesAuth item) {
            this.builder = new VaultKubernetesAuthBuilder(this, item);
        }

        AuthKubernetesNestedImpl() {
            this.builder = new VaultKubernetesAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultFluentImpl.this.withAuthKubernetes(this.builder.build());
        }

        @Override
        public N endAuthKubernetes() {
            return this.and();
        }
    }

    class AuthAppRoleNestedImpl<N>
    extends VaultAppRoleFluentImpl<VaultFluent.AuthAppRoleNested<N>>
    implements VaultFluent.AuthAppRoleNested<N>,
    Nested<N> {
        VaultAppRoleBuilder builder;

        AuthAppRoleNestedImpl(VaultAppRole item) {
            this.builder = new VaultAppRoleBuilder(this, item);
        }

        AuthAppRoleNestedImpl() {
            this.builder = new VaultAppRoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultFluentImpl.this.withAuthAppRole(this.builder.build());
        }

        @Override
        public N endAuthAppRole() {
            return this.and();
        }
    }

    class AuthTokenSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<VaultFluent.AuthTokenSecretRefNested<N>>
    implements VaultFluent.AuthTokenSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        AuthTokenSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        AuthTokenSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultFluentImpl.this.withAuthTokenSecretRef(this.builder.build());
        }

        @Override
        public N endAuthTokenSecretRef() {
            return this.and();
        }
    }
}

