/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.LocalObjectReferenceBuilder;
import io.dekorate.certmanager.config.LocalObjectReferenceFluentImpl;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import io.dekorate.certmanager.config.VaultKubernetesAuthFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class VaultKubernetesAuthFluentImpl<A extends VaultKubernetesAuthFluent<A>>
extends BaseFluent<A>
implements VaultKubernetesAuthFluent<A> {
    private String mountPath;
    private String role;
    private LocalObjectReferenceBuilder secretRef;

    public VaultKubernetesAuthFluentImpl() {
    }

    public VaultKubernetesAuthFluentImpl(VaultKubernetesAuth instance) {
        this.withMountPath(instance.getMountPath());
        this.withRole(instance.getRole());
        this.withSecretRef(instance.getSecretRef());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public A withRole(String role) {
        this.role = role;
        return (A)this;
    }

    @Override
    public Boolean hasRole() {
        return this.role != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get((Object)"secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String key) {
        return this.withSecretRef(new LocalObjectReference(name, key));
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultKubernetesAuthFluentImpl that = (VaultKubernetesAuthFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals(that.role) : that.role != null) {
            return false;
        }
        return !(this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.role, this.secretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<VaultKubernetesAuthFluent.SecretRefNested<N>>
    implements VaultKubernetesAuthFluent.SecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultKubernetesAuthFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

