/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.manifest;

import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ManifestGenerator;
import io.dekorate.ResourceRegistry;
import io.dekorate.certmanager.config.CertificateConfig;
import io.dekorate.certmanager.config.EditableCertificateConfig;
import io.dekorate.certmanager.decorator.AddCaIssuerResourceDecorator;
import io.dekorate.certmanager.decorator.AddCertificateResourceDecorator;
import io.dekorate.certmanager.decorator.AddSelfSignedIssuerResourceDecorator;
import io.dekorate.certmanager.decorator.AddVaultIssuerResourceDecorator;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountBuilder;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddSecretVolumeDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Strings;
import java.util.Objects;
import java.util.stream.Stream;

public class CertificateResourceGenerator
implements ManifestGenerator<CertificateConfig> {
    private static final String DEFAULT_VOLUME_NAME = "volume-certs";
    private static final String DEFAULT_VOLUME_MOUNT_PATH = "/etc/certs";
    private final ResourceRegistry resourceRegistry;
    private final ConfigurationRegistry configurationRegistry;
    private static final String CERTIFICATE = "certificate";
    private final Logger LOGGER = LoggerFactory.getLogger();

    public CertificateResourceGenerator(ResourceRegistry resources, ConfigurationRegistry configurationRegistry) {
        this.resourceRegistry = resources;
        this.configurationRegistry = configurationRegistry;
    }

    public int order() {
        return 600;
    }

    public String getKey() {
        return CERTIFICATE;
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(CertificateConfig.class) || type.equals(EditableCertificateConfig.class);
    }

    public void generate(CertificateConfig config) {
        this.LOGGER.info("Processing certificate config.");
        this.validate(config);
        String defaultName = this.configurationRegistry.get(BaseConfig.class).map(ApplicationConfiguration::getName).orElse(config.getProject().getBuildInfo().getName());
        String name = Strings.defaultIfEmpty((String)config.getName(), (String)defaultName);
        if (config.getVault() != null) {
            this.resourceRegistry.decorate((Decorator)new AddVaultIssuerResourceDecorator(config.getVault(), name));
        }
        if (config.getCa() != null) {
            this.resourceRegistry.decorate((Decorator)new AddCaIssuerResourceDecorator(config.getCa(), name));
        }
        if (config.getSelfSigned() != null) {
            this.resourceRegistry.decorate((Decorator)new AddSelfSignedIssuerResourceDecorator(config.getSelfSigned(), name));
        }
        this.resourceRegistry.decorate((Decorator)new AddCertificateResourceDecorator(name, config));
        String volumeName = Strings.defaultIfEmpty((String)config.getName(), (String)DEFAULT_VOLUME_NAME);
        this.resourceRegistry.decorate((Decorator)new AddMountDecorator((Mount)((MountBuilder)((MountBuilder)((MountBuilder)new MountBuilder().withName(Strings.defaultIfEmpty((String)config.getName(), (String)DEFAULT_VOLUME_NAME))).withPath(Strings.defaultIfEmpty((String)config.getVolumeMountPath(), (String)DEFAULT_VOLUME_MOUNT_PATH))).withReadOnly(Boolean.valueOf(true))).build()));
        this.resourceRegistry.decorate((Decorator)new AddSecretVolumeDecorator((SecretVolume)((SecretVolumeBuilder)((SecretVolumeBuilder)new SecretVolumeBuilder().withSecretName(config.getSecretName())).withVolumeName(volumeName)).build()));
    }

    public void validate(CertificateConfig config) {
        Object[] issuers = this.getAllIssuers(config);
        if (this.noneIssuerIsSet(issuers)) {
            throw new IllegalArgumentException("No issuer has been set in the certificate");
        }
        if (this.moreThanOneIssuerIsSet(issuers)) {
            throw new IllegalArgumentException("More then one issuer have been set in the certificate");
        }
    }

    private Object[] getAllIssuers(CertificateConfig config) {
        return new Object[]{config.getIssuerRef(), config.getCa(), config.getVault(), config.getSelfSigned()};
    }

    private boolean moreThanOneIssuerIsSet(Object ... issuers) {
        return Stream.of(issuers).filter(Objects::nonNull).count() > 1L;
    }

    private boolean noneIssuerIsSet(Object ... issuers) {
        return Stream.of(issuers).noneMatch(Objects::nonNull);
    }
}

