/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Ports;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.Optional;

@Description(value="Add a route to the list.")
public class AddRouteDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final OpenshiftConfig config;

    public AddRouteDecorator(OpenshiftConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        Optional p = Ports.getHttpPort((BaseConfig)this.config);
        if (!p.isPresent() || !this.config.isExpose()) {
            return;
        }
        if (this.contains(list, "route.openshift.io/v1", "Route", this.config.getName())) {
            return;
        }
        Port port = (Port)p.get();
        list.addToItems(new HasMetadata[]{((RouteBuilder)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(this.config.getName())).withLabels(Labels.createLabelsAsMap((BaseConfig)this.config, (String)"Route"))).endMetadata()).withNewSpec().withHost(this.config.getHost())).withPath(port.getPath())).withNewTo().withKind("Service")).withName(this.config.getName())).endTo()).withNewPort().withNewTargetPort(port.getContainerPort())).endPort()).endSpec()).build()});
    }
}

