package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.option.annotation.GarbageCollector;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class JvmConfig extends Configuration{
  public JvmConfig() {
  }
  public JvmConfig(Project project,Map<ConfigKey,Object> attributes,Integer xms,java.lang.Integer xmx,Boolean server,java.lang.Boolean useStringDeduplication,java.lang.Boolean preferIPv4Stack,java.lang.Boolean heapDumpOnOutOfMemoryError,java.lang.Boolean useGCOverheadLimit,GarbageCollector gc,SecureRandomSource secureRandom) {
    super(project, attributes);
    this.xms = xms;
    this.xmx = xmx;
    this.server = server;
    this.useStringDeduplication = useStringDeduplication;
    this.preferIPv4Stack = preferIPv4Stack;
    this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
    this.useGCOverheadLimit = useGCOverheadLimit;
    this.gc = gc;
    this.secureRandom = secureRandom;
  }
  private java.lang.Integer xms;
  private java.lang.Integer xmx;
  private java.lang.Boolean server;
  private java.lang.Boolean useStringDeduplication;
  private java.lang.Boolean preferIPv4Stack;
  private java.lang.Boolean heapDumpOnOutOfMemoryError;
  private java.lang.Boolean useGCOverheadLimit;
  private io.dekorate.option.annotation.GarbageCollector gc;
  private io.dekorate.option.annotation.SecureRandomSource secureRandom;
  
  /**
   * Starting heap size in megabytes.
   * @return The starting heap size in megabytes, or 0 if undefined.
   */
public java.lang.Integer getXms() {
    return this.xms;
  }
  
  /**
   * Maxium heap size in megabytes.
   * @return The maximum heap size in megabytes, or 0 if undefined.
   */
public java.lang.Integer getXmx() {
    return this.xmx;
  }
  
  /**
   * Server Flag.
   * @return True if server flag is used.
   */
public java.lang.Boolean getServer() {
    return this.server;
  }
  
  /**
   * Server Flag.
   * @return True if server flag is used.
   */
public boolean isServer() {
    return this.server != null &&  this.server;
  }
  
  /**
   * String deduplication flag.
   * @return True if string deduplication is enabled.
   */
public java.lang.Boolean getUseStringDeduplication() {
    return this.useStringDeduplication;
  }
  
  /**
   * String deduplication flag.
   * @return True if string deduplication is enabled.
   */
public boolean isUseStringDeduplication() {
    return this.useStringDeduplication != null &&  this.useStringDeduplication;
  }
  
  /**
   * Prefer IPv4 stack.
   * @return True if preferred.
   */
public java.lang.Boolean getPreferIPv4Stack() {
    return this.preferIPv4Stack;
  }
  
  /**
   * Prefer IPv4 stack.
   * @return True if preferred.
   */
public boolean isPreferIPv4Stack() {
    return this.preferIPv4Stack != null &&  this.preferIPv4Stack;
  }
  
  /**
   * Instructs the JVM to dump heap into physical file in case of OutOfMemoryError
   * @return True, if enabled.
   */
public java.lang.Boolean getHeapDumpOnOutOfMemoryError() {
    return this.heapDumpOnOutOfMemoryError;
  }
  
  /**
   * Instructs the JVM to dump heap into physical file in case of OutOfMemoryError
   * @return True, if enabled.
   */
public boolean isHeapDumpOnOutOfMemoryError() {
    return this.heapDumpOnOutOfMemoryError != null &&  this.heapDumpOnOutOfMemoryError;
  }
  
  /**
   * Is a policy that limits the proportion of the VM’s time that is spent in GC before an OutOfMemory error is thrown.
   * @return True if enabled.
   */
public java.lang.Boolean getUseGCOverheadLimit() {
    return this.useGCOverheadLimit;
  }
  
  /**
   * Is a policy that limits the proportion of the VM’s time that is spent in GC before an OutOfMemory error is thrown.
   * @return True if enabled.
   */
public boolean isUseGCOverheadLimit() {
    return this.useGCOverheadLimit != null &&  this.useGCOverheadLimit;
  }
  
  /**
   * Garbage Collector implementation.
   * @return The gc impl or Undefined if none is selected.
   */
public io.dekorate.option.annotation.GarbageCollector getGc() {
    return this.gc;
  }
  
  /**
   * The Secure random source to use.
   * This will determine -Djava.security.egd option.
   * @return The source to use. Defaults to undefined.
   */
public io.dekorate.option.annotation.SecureRandomSource getSecureRandom() {
    return this.secureRandom;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JvmConfig that = (JvmConfig) o;
    if (xms != null ? !xms.equals(that.xms) :that.xms != null) return false;
    if (xmx != null ? !xmx.equals(that.xmx) :that.xmx != null) return false;
    if (server != null ? !server.equals(that.server) :that.server != null) return false;
    if (useStringDeduplication != null ? !useStringDeduplication.equals(that.useStringDeduplication) :that.useStringDeduplication != null) return false;
    if (preferIPv4Stack != null ? !preferIPv4Stack.equals(that.preferIPv4Stack) :that.preferIPv4Stack != null) return false;
    if (heapDumpOnOutOfMemoryError != null ? !heapDumpOnOutOfMemoryError.equals(that.heapDumpOnOutOfMemoryError) :that.heapDumpOnOutOfMemoryError != null) return false;
    if (useGCOverheadLimit != null ? !useGCOverheadLimit.equals(that.useGCOverheadLimit) :that.useGCOverheadLimit != null) return false;
    if (gc != null ? !gc.equals(that.gc) :that.gc != null) return false;
    if (secureRandom != null ? !secureRandom.equals(that.secureRandom) :that.secureRandom != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(xms,  xmx,  server,  useStringDeduplication,  preferIPv4Stack,  heapDumpOnOutOfMemoryError,  useGCOverheadLimit,  gc,  secureRandom,  super.hashCode());
  }
  
}