package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceMonitorSpecFluent<A extends ServiceMonitorSpecFluent<A>> extends BaseFluent<A>{
  public ServiceMonitorSpecFluent() {
  }
  
  public ServiceMonitorSpecFluent(ServiceMonitorSpec instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder selector;
  private ArrayList<EndpointBuilder> endpoints;
  
  protected void copyInstance(ServiceMonitorSpec instance) {
    instance = (instance != null ? instance : new ServiceMonitorSpec());
    if (instance != null) {
          this.withSelector(instance.getSelector());
          this.withEndpoints(instance.getEndpoints());
        }
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public A addToEndpoints(int index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);
    if (index < 0 || index >= endpoints.size()) { _visitables.get("endpoints").add(builder); endpoints.add(builder); } else { _visitables.get("endpoints").add(index, builder); endpoints.add(index, builder);}
    return (A)this;
  }
  
  public A setToEndpoints(int index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);
    if (index < 0 || index >= endpoints.size()) { _visitables.get("endpoints").add(builder); endpoints.add(builder); } else { _visitables.get("endpoints").set(index, builder); endpoints.set(index, builder);}
    return (A)this;
  }
  
  public A addToEndpoints(io.dekorate.prometheus.model.Endpoint... items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  
  public A addAllToEndpoints(Collection<Endpoint> items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  
  public A removeFromEndpoints(io.dekorate.prometheus.model.Endpoint... items) {
    if (this.endpoints == null) return (A)this;
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder); this.endpoints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEndpoints(Collection<Endpoint> items) {
    if (this.endpoints == null) return (A)this;
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder); this.endpoints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<EndpointBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      EndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Endpoint> buildEndpoints() {
    return this.endpoints != null ? build(endpoints) : null;
  }
  
  public Endpoint buildEndpoint(int index) {
    return this.endpoints.get(index).build();
  }
  
  public Endpoint buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  
  public Endpoint buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  
  public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
      for (EndpointBuilder item : endpoints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
      for (EndpointBuilder item : endpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEndpoints(List<Endpoint> endpoints) {
    if (this.endpoints != null) {
      this._visitables.get("endpoints").clear();
    }
    if (endpoints != null) {
        this.endpoints = new ArrayList();
        for (Endpoint item : endpoints) {
          this.addToEndpoints(item);
        }
    } else {
      this.endpoints = null;
    }
    return (A) this;
  }
  
  public A withEndpoints(io.dekorate.prometheus.model.Endpoint... endpoints) {
    if (this.endpoints != null) {
        this.endpoints.clear();
        _visitables.remove("endpoints");
    }
    if (endpoints != null) {
      for (Endpoint item : endpoints) {
        this.addToEndpoints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEndpoints() {
    return this.endpoints != null && !this.endpoints.isEmpty();
  }
  
  public EndpointsNested<A> addNewEndpoint() {
    return new EndpointsNested(-1, null);
  }
  
  public EndpointsNested<A> addNewEndpointLike(Endpoint item) {
    return new EndpointsNested(-1, item);
  }
  
  public EndpointsNested<A> setNewEndpointLike(int index,Endpoint item) {
    return new EndpointsNested(index, item);
  }
  
  public EndpointsNested<A> editEndpoint(int index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  
  public EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceMonitorSpecFluent that = (ServiceMonitorSpecFluent) o;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(selector,  endpoints,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ServiceMonitorSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class EndpointsNested<N> extends EndpointFluent<EndpointsNested<N>> implements Nested<N>{
    EndpointsNested(int index,Endpoint item) {
      this.index = index;
      this.builder = new EndpointBuilder(this, item);
    }
    EndpointBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceMonitorSpecFluent.this.setToEndpoints(index,builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }

}