/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.decorator;

import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.prometheus.model.EndpointBuilder;
import io.dekorate.prometheus.model.ServiceMonitorBuilder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;

public class EndpointPathDecorator
extends NamedResourceDecorator<ServiceMonitorBuilder> {
    private final String port;
    private final String path;

    public EndpointPathDecorator(String port, String path) {
        this(ANY, port, path);
    }

    public EndpointPathDecorator(String name, String port, String path) {
        super(name);
        this.port = port;
        this.path = path;
    }

    public void andThenVisit(ServiceMonitorBuilder serviceMonitor, ObjectMeta resourceMeta) {
        serviceMonitor.accept(new Visitor[]{new TypedVisitor<EndpointBuilder>(){

            public void visit(EndpointBuilder endpoint) {
                if (EndpointPathDecorator.this.port.equals(endpoint.getPort())) {
                    endpoint.withPath(EndpointPathDecorator.this.path);
                }
            }
        }});
    }
}

