/*
 * Decompiled with CFR 0.152.
 */
package io.escalante.lift;

import io.escalante.lift.AbstractScalaSubsystemTest;
import io.escalante.lift.subsystem.LiftExtension$;
import io.escalante.lift.subsystem.LiftService;
import io.escalante.lift.subsystem.LiftService$;
import io.escalante.lift.subsystem.ThirdPartyModulesRepo$;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.ControllerInitializer;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Test;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001-3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\t!\u0003\u0002\u0016\u0019&4GoU;cgf\u001cH/Z7V]&$H+Z:u\u0015\t\u0019A!\u0001\u0003mS\u001a$(BA\u0003\u0007\u0003%)7oY1mC:$XMC\u0001\b\u0003\tIwn\u0001\u0001\u0014\u0007\u0001Qa\u0002\u0005\u0002\f\u00195\t!!\u0003\u0002\u000e\u0005\tQ\u0012IY:ue\u0006\u001cGoU2bY\u0006\u001cVOY:zgR,W\u000eV3tiB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\tY1kY1mC>\u0013'.Z2u\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\f\u0001!)\u0011\u0004\u0001C\u00015\u0005\u0011B/Z:u!\u0006\u00148/Z*vENL8\u000f^3n)\u0005Y\u0002CA\b\u001d\u0013\ti\u0002C\u0001\u0003V]&$\bF\u0001\r !\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0003kk:LGOC\u0001%\u0003\ry'oZ\u0005\u0003M\u0005\u0012A\u0001V3ti\")\u0001\u0006\u0001C\u00015\u0005qB/Z:u!\u0006\u00148/\u001a+iSJ$\u0007/\u0019:us6{G-\u001e7fgJ+\u0007o\u001c\u0015\u0003O}AQa\u000b\u0001\u0005\u0002i\t\u0001\u0004^3ti&s7\u000f^1mY2Kg\r^*vENL8\u000f^3nQ\tQs\u0004C\u0003/\u0001\u0011\u0005!$A\u001auKN$\u0018J\\:uC2dw+\u001b;i'f\u001c\bK]8qKJ$\u0018\u0010\u00165je\u0012\u0004\u0018M\u001d;z\u001b>$W\u000f\\3t%\u0016\u0004x\u000eU1uQ\"\u0012Qf\b\u0004\tc\u0001!\t\u0011!A\u0001e\t\u0011\u0002+\u0019;i\u0013:LG/[1mSj\fG/[8o'\r\u00014G\u0004\t\u0003iuj\u0011!\u000e\u0006\u0003m]\nA\u0001^3ti*\u0011\u0001(O\u0001\ngV\u00147/_:uK6T!AO\u001e\u0002\u0005\u0005\u001c(B\u0001\u001f$\u0003\u0015Q'm\\:t\u0013\tqTG\u0001\rBI\u0012LG/[8oC2Le.\u001b;jC2L'0\u0019;j_:DQ!\u0006\u0019\u0005\u0002\u0001#\u0012!\u0011\t\u0003\u0005Bj\u0011\u0001\u0001\u0005\u0006\tB\"\t%R\u0001\u0010g\u0016$X\u000f]\"p]R\u0014x\u000e\u001c7feR\u00111D\u0012\u0005\u0006\u000f\u000e\u0003\r\u0001S\u0001\u0005S:LG\u000f\u0005\u00025\u0013&\u0011!*\u000e\u0002\u0016\u0007>tGO]8mY\u0016\u0014\u0018J\\5uS\u0006d\u0017N_3s\u0001")
public class LiftSubsystemUnitTest
extends AbstractScalaSubsystemTest
implements ScalaObject {
    @Test
    public void testParseSubsystem() {
        TopScope$ $tmpscope = package$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, LiftExtension$.MODULE$.SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
        Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        Iterable<ModelNode> operations = super.parse(subsystemXml);
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)operations.size())));
        ModelNode op = (ModelNode)operations.head();
        this.assert(this.convertToEqualizer("add").$eq$eq$eq((Object)op.get("operation").asString()));
        PathAddress addr = PathAddress.pathAddress((ModelNode)op.get("address"));
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)addr.size())));
        PathElement element = addr.getElement(0);
        this.assert(this.convertToEqualizer("subsystem").$eq$eq$eq((Object)element.getKey()));
        this.assert(this.convertToEqualizer(LiftExtension$.MODULE$.SUBSYSTEM_NAME()).$eq$eq$eq((Object)element.getValue()));
        this.assert(!op.hasDefined(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()));
        this.assert(!op.hasDefined(ThirdPartyModulesRepo$.MODULE$.PATH()));
    }

    @Test
    public void testParseThirdpartyModulesRepo() {
        TopScope$ $tmpscope = package$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, LiftExtension$.MODULE$.SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("relative-to", (Seq)new Text("x"), (MetaData)$md);
        $md = new UnprefixedAttribute("path", (Seq)new Text("y"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "thirdparty-modules-repo", (MetaData)$md, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf);
        Iterable<ModelNode> operations = super.parse(subsystemXml);
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)operations.size())));
        ModelNode op = (ModelNode)operations.head();
        this.assert(this.convertToEqualizer("add").$eq$eq$eq((Object)op.get("operation").asString()));
        PathAddress addr = PathAddress.pathAddress((ModelNode)op.get("address"));
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)addr.size())));
        PathElement element = addr.getElement(0);
        this.assert(this.convertToEqualizer("subsystem").$eq$eq$eq((Object)element.getKey()));
        this.assert(this.convertToEqualizer(LiftExtension$.MODULE$.SUBSYSTEM_NAME()).$eq$eq$eq((Object)element.getValue()));
        this.assert(this.convertToEqualizer("x").$eq$eq$eq((Object)op.get(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()).asString()));
        this.assert(this.convertToEqualizer("y").$eq$eq$eq((Object)op.get(ThirdPartyModulesRepo$.MODULE$.PATH()).asString()));
    }

    @Test
    public void testInstallLiftSubsystem() {
        TopScope$ $tmpscope = package$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, LiftExtension$.MODULE$.SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
        Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        KernelServices services = super.installInController(new PathInitialization(this), subsystemXml);
        ModelNode model = services.readWholeModel();
        this.assert(model.get("subsystem").hasDefined(LiftExtension$.MODULE$.SUBSYSTEM_NAME()));
        ModelNode liftNode = model.get("subsystem").get(LiftExtension$.MODULE$.SUBSYSTEM_NAME());
        this.assert(!liftNode.hasDefined(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()));
        this.assert(!liftNode.hasDefined(ThirdPartyModulesRepo$.MODULE$.PATH()));
    }

    @Test
    public void testInstallWithSysPropertyThirdpartyModulesRepoPath() {
        String key = "my.path.expression";
        String value = "lift1234";
        System.setProperty(key, value);
        try {
            TopScope$ $tmpscope = package$.MODULE$.$scope();
            TopScope$ $scope = $tmpscope = new NamespaceBinding(null, LiftExtension$.MODULE$.SUBSYSTEM_NAMESPACE(), (NamespaceBinding)$tmpscope);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("path", (Seq)new Text("/path/${my.path.expression}"), (MetaData)$md);
            $buf.$amp$plus((Object)new Elem(null, "thirdparty-modules-repo", (MetaData)$md, (NamespaceBinding)$scope, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem subsystemXml = new Elem(null, "subsystem", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf);
            KernelServices services = super.installInController(new PathInitialization(this), subsystemXml);
            ModelNode model = services.readWholeModel();
            this.assert(model.get("subsystem").hasDefined(LiftExtension$.MODULE$.SUBSYSTEM_NAME()));
            ModelNode liftNode = model.get("subsystem").get(LiftExtension$.MODULE$.SUBSYSTEM_NAME());
            this.assert(!liftNode.hasDefined(ThirdPartyModulesRepo$.MODULE$.RELATIVE_TO()));
            LiftService liftService = (LiftService)services.getContainer().getService(LiftService$.MODULE$.createServiceName()).getValue();
            this.assert(this.convertToEqualizer(new StringBuilder().append((Object)"/path/").append((Object)value).toString()).$eq$eq$eq((Object)liftService.thirdPartyModulesPath()));
            this.assert(this.convertToEqualizer(new StringBuilder().append((Object)"/path/${").append((Object)key).append((Object)"}").toString()).$eq$eq$eq((Object)liftNode.get(ThirdPartyModulesRepo$.MODULE$.PATH()).asString()));
            return;
        }
        finally {
            System.clearProperty(key);
        }
    }

    public class PathInitialization
    extends AdditionalInitialization
    implements ScalaObject {
        public final LiftSubsystemUnitTest $outer;

        public void setupController(ControllerInitializer init) {
            init.addPath("jboss.home.dir", "thirdparty-modules", null);
        }

        public LiftSubsystemUnitTest io$escalante$lift$LiftSubsystemUnitTest$PathInitialization$$$outer() {
            return this.$outer;
        }

        public PathInitialization(LiftSubsystemUnitTest $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

