/**
 *  Copyright 2005-2015 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package io.fabric8.api;

/**
 * Represents a command request to auto-scale
 */
public class AutoScaleRequest {
    private final FabricService fabricService;
    private final String version;
    private final String profile;
    private final int delta;
    private final FabricRequirements fabricRequirements;
    private final ProfileRequirements profileRequirements;
    private final AutoScaleStatus status;

    public AutoScaleRequest(FabricService fabricService, String version, String profile, int delta, FabricRequirements fabricRequirements, ProfileRequirements profileRequirements, AutoScaleStatus status) {
        this.fabricService = fabricService;
        this.version = version;
        this.profile = profile;
        this.delta = delta;
        this.fabricRequirements = fabricRequirements;
        this.profileRequirements = profileRequirements;
        this.status = status;
    }

    public FabricService getFabricService() {
        return fabricService;
    }

    public String getVersion() {
        return version;
    }

    public String getProfile() {
        return profile;
    }

    public int getDelta() {
        return delta;
    }

    public FabricRequirements getFabricRequirements() {
        return fabricRequirements;
    }

    public ProfileRequirements getProfileRequirements() {
        return profileRequirements;
    }

    public AutoScaleStatus getStatus() {
        return status;
    }

    public AutoScaleProfileStatus getProfileAutoScaleStatus() {
        return status.profileStatus(profile);
    }
}
