/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpsWagon;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.impl.internal.DefaultServiceLocator;
import org.sonatype.aether.impl.internal.Slf4jLogger;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.log.Logger;

public class RepositorySystemFactory
extends DefaultServiceLocator {
    public static RepositorySystem newRepositorySystem() throws Exception {
        return new RepositorySystemFactory().getService(RepositorySystem.class);
    }

    public RepositorySystemFactory() {
        this.setService(Logger.class, LogAdapter.class);
        this.setService(WagonProvider.class, StaticWagonProvider.class);
        this.setService(VersionResolver.class, DefaultVersionResolver.class);
        this.setService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        this.setService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        this.setService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
    }

    public static class StaticWagonProvider
    implements WagonProvider {
        @Override
        public Wagon lookup(String roleHint) throws Exception {
            if ("file".equals(roleHint)) {
                return new FileWagon();
            }
            if ("http".equals(roleHint)) {
                return new LightweightHttpWagon();
            }
            if ("https".equals(roleHint)) {
                return new LightweightHttpsWagon();
            }
            return null;
        }

        @Override
        public void release(Wagon wagon) {
        }
    }

    public static class LogAdapter
    extends Slf4jLogger {
        public LogAdapter() {
            super(LoggerFactory.getLogger((String)"org.apache.karaf.pomegranate.Aether"));
        }
    }
}

