/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.util;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.common.util.Objects;
import org.fusesource.common.util.Strings;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class Service {
    private final String className;
    private final Map<String, String> properties;

    public Service(String className) {
        this(className, new HashMap<String, String>());
    }

    public Service(String className, Map<String, String> properties) {
        this.className = className;
        this.properties = properties;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.className, this.properties});
    }

    public boolean equals(Object o) {
        if (o instanceof Service) {
            Service other = (Service)o;
            return Objects.equal((Object)this.className, (Object)other.getClassName()) && Objects.equal(this.properties, other.getProperties());
        }
        return false;
    }

    public static Service parse(String header) {
        String[] parts = header.split(";");
        HashMap<String, String> properties = new HashMap<String, String>();
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                String[] keyvalue = parts[i].split("=");
                if (keyvalue.length != 2 || !Strings.notEmpty((String)Strings.unquote((String)keyvalue[1]))) continue;
                properties.put(keyvalue[0], Strings.unquote((String)keyvalue[1]));
            }
        }
        return new Service(parts[0], properties);
    }

    protected boolean isAvailable(BundleContext context) throws InvalidSyntaxException {
        return context.getServiceReferences(this.className, this.getFilter()) != null;
    }

    public String getFilter() {
        if (this.properties.size() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.properties.size() > 1) {
            buffer.append("(&");
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            buffer.append(String.format("(%s=%s)", entry.getKey(), entry.getValue()));
        }
        if (this.properties.size() > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }
}

