/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.commands.fab;

import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.osgi.commands.fab.FabCommandSupport;
import io.fabric8.fab.osgi.commands.fab.UninstallCommand;
import io.fabric8.fab.osgi.internal.Bundles;
import io.fabric8.fab.osgi.internal.FabClassPathResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessUnusedBundles
extends FabCommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(UninstallCommand.class);

    @Override
    protected void doExecute(Bundle bundle, FabClassPathResolver resolver) throws Exception {
        List<DependencyTree> sharedDependencies = resolver.getSharedDependencies();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (DependencyTree dependency : sharedDependencies) {
            this.addBundlesForDependency(dependency, bundles);
        }
        bundles.add(bundle);
        HashSet<Bundle> bundleSet = new HashSet<Bundle>(bundles);
        for (Bundle b : bundles) {
            if (this.bundleUsedByOtherBundles(b, bundleSet)) continue;
            this.processBundle(b);
        }
    }

    protected void addBundlesForDependency(DependencyTree dependency, List<Bundle> bundles) throws IOException {
        String version;
        String name = dependency.getBundleSymbolicName();
        Bundle bundle = Bundles.findBundle(this.bundleContext, name, version = dependency.getVersion());
        if (bundle != null) {
            bundles.add(bundle);
        }
    }

    protected boolean bundleUsedByOtherBundles(Bundle bundle, Set<Bundle> bundleSet) {
        ExportedPackage[] exportedPackages = this.getPackageAdmin().getExportedPackages(bundle);
        if (exportedPackages != null) {
            for (ExportedPackage exportedPackage : exportedPackages) {
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (importingBundle.equals(bundle) || bundleSet.contains(importingBundle)) continue;
                    System.out.println("Not processing bundle " + bundle + " as its used by " + importingBundle);
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract void processBundle(Bundle var1) throws Exception;
}

