/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.commands.module;

import io.fabric8.fab.ModuleRegistry;
import io.fabric8.fab.VersionedDependencyId;
import io.fabric8.fab.osgi.commands.CommandSupport;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.common.util.Strings;
import org.osgi.framework.Bundle;

@Command(name="list", scope="module", description="List the installed modules")
public class ListCommand
extends CommandSupport {
    @Argument(index=0, required=false, description="Name of the module to list")
    private String name;

    protected Object doExecute() throws Exception {
        OsgiModuleRegistry registry = this.getModuleRegistry();
        List<ModuleRegistry.Module> modules = registry.getApplicationModules();
        Map<VersionedDependencyId, Bundle> installed = registry.getInstalled();
        CommandSupport.Table table = new CommandSupport.Table("{1} | {2} | {3} | {4}", 3, -20, -10, -40);
        table.add("Id", "Name", "Version", "Description");
        for (ModuleRegistry.Module module : modules) {
            ModuleRegistry.VersionedModule latest = module.latest();
            HashSet<VersionedDependencyId> s = new HashSet<VersionedDependencyId>(module.getVersionIds());
            s.retainAll(installed.keySet());
            if (s.isEmpty() || this.name != null && module.getName().indexOf(this.name) < 0) continue;
            HashSet<Long> bundles = new HashSet<Long>();
            for (VersionedDependencyId dependencyId : s) {
                bundles.add(installed.get(dependencyId).getBundleId());
            }
            table.add(Strings.join(bundles, (String)", "), module.getName(), latest.getId().getVersion(), latest.getDescription());
        }
        table.print(this.session.getConsole());
        return null;
    }
}

