/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import io.fabric8.common.util.Strings;
import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.PomDetails;
import io.fabric8.fab.osgi.FabBundleInfo;
import io.fabric8.fab.osgi.FabResolver;
import io.fabric8.fab.osgi.FabResolverFactory;
import io.fabric8.fab.osgi.internal.Bundles;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.internal.ConfigurationImpl;
import io.fabric8.fab.osgi.internal.FabFacadeSupport;
import io.fabric8.fab.osgi.internal.ServiceProvider;
import io.fabric8.fab.osgi.internal.VersionResolver;
import io.fabric8.fab.osgi.util.Service;
import io.fabric8.fab.osgi.util.Services;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabConnection
extends URLConnection {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabConnection.class);
    private final BundleContext bundleContext;
    private final FabResolver resolver;
    private Configuration configuration;
    private final FabResolverFactory fabResolverFactory;
    private final ServiceProvider serviceProvider;

    public FabConnection(URL url, FabResolverFactory fabResolverFactory, ServiceProvider serviceProvider) throws IOException {
        super(url);
        this.fabResolverFactory = fabResolverFactory;
        this.serviceProvider = serviceProvider;
        this.configuration = ConfigurationImpl.newInstance(serviceProvider.getConfigurationAdmin(), serviceProvider.getBundleContext());
        this.bundleContext = serviceProvider.getBundleContext();
        this.resolver = fabResolverFactory.getResolver(url);
        if (this.resolver == null) {
            throw new IOException("Unable to create FAB resolver for " + url);
        }
    }

    @Override
    public void connect() {
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public FabConnection createChild(URL url) throws IOException {
        return new FabConnection(url, this.fabResolverFactory, this.serviceProvider);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        try {
            FabBundleInfo info = this.resolver.getInfo();
            HashSet<String> actualImports = new HashSet<String>();
            actualImports.addAll(info.getImports());
            InputStream rc = info.getInputStream();
            this.installMissingFeatures(info);
            if (this.configuration.isInstallMissingDependencies()) {
                this.installMissingDependencies(info, actualImports);
            } else {
                LOG.info("Not installing dependencies as not enabled");
            }
            return rc;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installMissingFeatures(FabBundleInfo info) {
        ServiceReference reference = this.bundleContext.getServiceReference(FeaturesService.class.getName());
        try {
            FeaturesService service = (FeaturesService)this.bundleContext.getService(reference);
            for (URI uri : info.getFeatureURLs()) {
                try {
                    service.addRepository(uri);
                }
                catch (Exception e) {
                    LOG.warn("Unable to add feature repository URL {} - FAB {} may not get installed properly", (Object)uri, (Object)this.url);
                }
            }
            for (String feature : info.getFeatures()) {
                try {
                    this.installMissingFeature(service, feature);
                }
                catch (Exception e) {
                    LOG.warn(String.format("Unable to install missing feature %s - FAB %s may not get installed properly", feature, this.url), (Throwable)e);
                }
            }
        }
        finally {
            this.bundleContext.ungetService(reference);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void installMissingFeature(FeaturesService service, String feature) throws Exception {
        if (feature.contains("/")) {
            String[] parts = feature.split("/");
            if (parts.length != 2) throw new IllegalStateException(String.format("Invalid feature identifier: %s - valid syntax: <name>/<version> or <name>", feature));
            service.installFeature(parts[0], parts[1]);
            return;
        } else {
            service.installFeature(feature);
        }
    }

    protected void installMissingDependencies(FabBundleInfo info, HashSet<String> actualImports) throws IOException, BundleException, InvalidSyntaxException {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            LOG.warn("No BundleContext available so cannot install provided dependencies");
        } else {
            for (DependencyTree dependency : info.getBundles()) {
                String importPackages;
                if (!dependency.isBundle() || !Strings.notEmpty((String)(importPackages = dependency.getManifestEntry("Import-Package")))) continue;
                Map<String, Map<String, String>> values = new Analyzer().parseHeader(importPackages);
                for (Map.Entry<String, Map<String, String>> entry : values.entrySet()) {
                    String res = entry.getValue().get("resolution:");
                    if ("optional".equals(res)) continue;
                    actualImports.add(entry.getKey());
                }
            }
            for (DependencyTree dependency : info.getBundles()) {
                String version;
                String name = dependency.getBundleSymbolicName();
                if (Bundles.isInstalled(bundleContext, name, version = dependency.getVersion())) {
                    LOG.info("Bundle already installed: " + name + " (" + version + ")");
                    continue;
                }
                HashSet<String> p = new HashSet<String>(dependency.getPackages());
                p.retainAll(actualImports);
                Set<String> missing = Bundles.filterInstalled(bundleContext, p, (VersionResolver)((Object)info));
                boolean hasNoPendingPackagesOrServices = false;
                if (missing.isEmpty()) {
                    Set<Service> services = Services.parseHeader(dependency.getManifestEntry("Export-Service"));
                    if (services.isEmpty() || Services.isAvailable(bundleContext, services)) {
                        hasNoPendingPackagesOrServices = true;
                    } else if (Services.isAvailable(bundleContext, services)) {
                        LOG.info("Bundle non-optional packages already installed for: " + name + " version: " + version + " but it exposes services that are not currently available so will install: " + services);
                    }
                }
                if (hasNoPendingPackagesOrServices) {
                    LOG.info("Bundle non-optional packages already installed for: " + name + " version: " + version + " packages: " + p);
                    continue;
                }
                LOG.info("Packages not yet shared: " + missing);
                URL url = dependency.getJarURL();
                String installUri = url.toExternalForm();
                try {
                    Bundle bundle = null;
                    if (!dependency.isBundle()) {
                        FabConnection childConnection = this.createChild(url);
                        PomDetails pomDetails = childConnection.resolver.getInfo().getPomDetails();
                        if (pomDetails != null && pomDetails.isValid()) {
                            LOG.info("Installing fabric bundle: " + name + " from: " + installUri);
                            bundle = bundleContext.installBundle(installUri, childConnection.getInputStream());
                            continue;
                        }
                        LOG.warn("Could not deduce the pom.xml for the jar " + installUri + " so cannot treat as FAB");
                        continue;
                    }
                    LOG.info("Installing bundle: " + name + " from: " + installUri);
                    bundle = bundleContext.installBundle(installUri);
                }
                catch (BundleException e) {
                    LOG.error("Failed to deploy " + installUri + " due to error: " + (Object)((Object)e), (Throwable)e);
                    throw e;
                }
                catch (IOException e) {
                    LOG.error("Failed to deploy " + installUri + " due to error: " + e, (Throwable)e);
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.error("Failed to deploy " + installUri + " due to error: " + e, (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public boolean isInstalled(DependencyTree tree) {
        return FabFacadeSupport.isInstalled(this.getBundleContext(), tree);
    }
}

