/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import io.fabric8.common.util.Strings;
import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.PomDetails;
import io.fabric8.fab.osgi.FabBundleInfo;
import io.fabric8.fab.osgi.internal.BndUtils;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.internal.FabClassPathResolver;
import io.fabric8.fab.osgi.internal.OverwriteMode;
import io.fabric8.fab.osgi.internal.VersionResolver;
import io.fabric8.fab.osgi.internal.Versions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.felix.utils.version.VersionCleaner;
import org.ops4j.net.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabBundleInfoImpl
implements FabBundleInfo,
VersionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(FabBundleInfo.class);
    private final FabClassPathResolver classPathResolver;
    private final String fabUri;
    private final Properties instructions;
    private final Configuration configuration;
    private final Map<String, Object> embeddedResources;
    private final PomDetails pomDetails;
    private final Set<String> actualImports = new HashSet<String>();
    private final Jar jar;

    public FabBundleInfoImpl(FabClassPathResolver classPathResolver, String fabUri, Properties instructions, Configuration configuration, Map<String, Object> embeddedResources, PomDetails pomDetails) throws Exception {
        this.classPathResolver = classPathResolver;
        this.fabUri = fabUri;
        this.instructions = instructions;
        this.configuration = configuration;
        this.embeddedResources = embeddedResources;
        this.pomDetails = pomDetails;
        this.jar = this.getOrCreateJar();
    }

    private Jar getOrCreateJar() throws Exception {
        if (this.jar != null && this.jar.getResources() != null) {
            return this.jar;
        }
        return BndUtils.createJar(URLUtils.prepareInputStream((URL)new URL(this.fabUri), (boolean)this.configuration.getCertificateCheck()), this.instructions, this.fabUri, OverwriteMode.MERGE, this.embeddedResources, this.classPathResolver.getExtraImportPackages(), this.actualImports, this);
    }

    @Override
    public String getUrl() {
        return this.fabUri;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return BndUtils.createInputStream(this.getOrCreateJar());
    }

    @Override
    public Attributes getManifest() {
        try {
            return this.getOrCreateJar().getManifest().getMainAttributes();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Set<String> getImports() {
        return Collections.unmodifiableSet(this.actualImports);
    }

    @Override
    public Collection<DependencyTree> getBundles() {
        return this.classPathResolver.getInstallDependencies();
    }

    @Override
    public Collection<URI> getFeatureURLs() {
        return this.classPathResolver.getInstallFeatureURLs();
    }

    @Override
    public Collection<String> getFeatures() {
        return this.classPathResolver.getInstallFeatures();
    }

    @Override
    public PomDetails getPomDetails() {
        return this.pomDetails;
    }

    @Override
    public String resolvePackageVersion(String packageName) {
        DependencyTree dependency = this.resolvePackageDependency(packageName);
        if (dependency != null) {
            String version;
            Map<String, Map<String, String>> values;
            Map<String, String> map;
            String exportPackages;
            if (dependency.isBundle() && Strings.notEmpty((String)(exportPackages = dependency.getManifestEntry("Export-Package"))) && (map = (values = new Analyzer().parseHeader(exportPackages)).get(packageName)) != null) {
                String version2 = map.get("version");
                if (version2 == null) {
                    version2 = map.get("specification-version");
                }
                if (version2 != null) {
                    return this.toVersionRange(version2);
                }
            }
            if ((version = dependency.getVersion()) != null) {
                String osgiVersion = VersionCleaner.clean((String)version);
                return this.toVersionRange(osgiVersion);
            }
        }
        return null;
    }

    @Override
    public String resolveExportPackageVersion(String packageName) {
        DependencyTree dependency;
        ArrayList<DependencyTree> dependencies = new ArrayList<DependencyTree>(this.classPathResolver.getSharedDependencies());
        DependencyTree rootTree = this.classPathResolver.getRootTree();
        if (rootTree != null) {
            dependencies.add(rootTree);
        }
        if ((dependency = this.resolvePackageDependency(packageName, dependencies)) != null) {
            return Versions.getOSGiPackageVersion(dependency, packageName);
        }
        return null;
    }

    @Override
    public boolean isPackageOptional(String packageName) {
        DependencyTree dependency = this.resolvePackageDependency(packageName);
        if (dependency != null) {
            return dependency.isThisOrDescendantOptional() && this.classPathResolver.getOptionalDependencyFilter().matches((Object)dependency);
        }
        return true;
    }

    public DependencyTree resolvePackageDependency(String packageName) {
        return this.resolvePackageDependency(packageName, this.classPathResolver.getSharedDependencies());
    }

    protected DependencyTree resolvePackageDependency(String packageName, List<DependencyTree> dependencies) {
        for (DependencyTree dependency : dependencies) {
            try {
                Set<String> packages = dependency.getPackages();
                if (!packages.contains(packageName)) continue;
                return dependency;
            }
            catch (IOException e) {
                LOG.warn("Failed to get the packages on dependency: " + dependency + ". " + e, (Throwable)e);
            }
        }
        return null;
    }

    public String toVersionRange(String version) {
        int digits = 3;
        String value = this.classPathResolver.getManifestProperty("FAB-Version-Range-Digits");
        if (Strings.notEmpty((String)value)) {
            try {
                digits = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse manifest header FAB-Version-Range-Digits as a number. Got: '" + value + "' so ignoring it");
            }
            if (digits < 0 || digits > 4) {
                LOG.warn("Invalid value of manifest header FAB-Version-Range-Digits as value " + digits + " is out of range so ignoring it");
                digits = 3;
            }
        }
        return Versions.toVersionRange(version, digits);
    }
}

