/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.commands.module;

import io.fabric8.common.util.Strings;
import io.fabric8.fab.ModuleDescriptor;
import io.fabric8.fab.ModuleRegistry;
import io.fabric8.fab.VersionedDependencyId;
import io.fabric8.fab.osgi.commands.CommandSupport;
import io.fabric8.fab.osgi.internal.Activator;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.osgi.framework.Bundle;

@Command(name="show", scope="module", description="Display details about a module.")
public class ShowCommand
extends CommandSupport {
    @Argument(index=0, required=true, description="Name of the module to display.")
    private String name;
    @Option(name="--version", multiValued=false, required=false)
    private String version;

    protected Object doExecute() throws Exception {
        OsgiModuleRegistry registry = Activator.registry;
        List<ModuleRegistry.Module> modules = registry.getApplicationModules();
        Map<VersionedDependencyId, Bundle> installed = registry.getInstalled();
        for (ModuleRegistry.Module module : modules) {
            if (!module.getName().equals(this.name)) continue;
            ModuleRegistry.VersionedModule selected = null;
            TreeSet<String> versions = this.mapVersion(module.getVersionIds());
            HashSet<VersionedDependencyId> installedVersionIds = new HashSet<VersionedDependencyId>(module.getVersionIds());
            installedVersionIds.retainAll(installed.keySet());
            TreeSet<String> installedVersions = this.mapVersion(installedVersionIds);
            versions.removeAll(installedVersions);
            if (this.version != null) {
                selected = module.getVersions().get(this.version);
                if (selected == null) {
                    this.println("Unknown version: %s", this.version);
                    return null;
                }
            } else {
                selected = module.latest();
            }
            this.println("%15s: %s", "Name", selected.getName());
            if (!installedVersionIds.isEmpty()) {
                for (VersionedDependencyId id : installedVersionIds) {
                    Bundle bundle = installed.get(id);
                    String version = id.getVersion();
                    String extensionIds = (String)bundle.getHeaders().get("FAB-Enabled-Extensions");
                    if (Strings.notEmpty((String)extensionIds)) {
                        List<VersionedDependencyId> ids = ModuleDescriptor.decodeVersionList(extensionIds);
                        ArrayList<String> ext = new ArrayList<String>();
                        for (VersionedDependencyId x : ids) {
                            ModuleRegistry.VersionedModule vm = registry.getVersionedModule(x);
                            if (vm == null) continue;
                            ext.add(vm.getName());
                        }
                        if (!ext.isEmpty()) {
                            version = version + ", Extensions: " + Strings.join(ext, (String)" ") + "";
                        }
                    }
                    this.println("%15s: %s, Bundle: %d", "Installed", version, bundle.getBundleId());
                }
            }
            if (!versions.isEmpty()) {
                this.println("%15s: %s", "Available", Strings.join(versions, (String)", "));
            }
            String desc = Strings.notEmpty((String)selected.getLongDescription()) ? selected.getLongDescription() : selected.getDescription();
            String[] lines = this.wordWrap(desc, 60);
            this.println("%15s: %s", "Description", lines[0]);
            for (int i = 1; i < lines.length; ++i) {
                this.println("%15s  %s", "", lines[i]);
            }
            Map<String, ModuleRegistry.VersionedModule> extensions = selected.getAvailableExtensions();
            if (extensions.size() <= 0) continue;
            HashSet<String> enabled = new HashSet<String>(selected.getEnabledExtensions());
            this.println("%15s: %s", "Extensions", selected.getDefaultExtensions().isEmpty() ? "" : "(Default: " + Strings.join(selected.getDefaultExtensions(), (String)", ") + ")");
            CommandSupport.Table table = new CommandSupport.Table("       {1} | {2} | {3}", -20, -10, -40);
            table.add("Name", "Version", "Description");
            for (Map.Entry<String, ModuleRegistry.VersionedModule> entry : extensions.entrySet()) {
                ModuleRegistry.VersionedModule extension = entry.getValue();
                table.add(extension.getName(), extension.getId().getVersion(), extension.getDescription());
            }
            table.print(this.session.getConsole());
        }
        return null;
    }

    private TreeSet<String> mapVersion(Collection<VersionedDependencyId> versionIds) {
        TreeSet<String> versions = new TreeSet<String>();
        for (VersionedDependencyId id : versionIds) {
            String v = id.getVersion();
            versions.add(v);
        }
        return versions;
    }

    private String[] wordWrap(String desc, int max) {
        ArrayList<String> lines = new ArrayList<String>();
        LinkedList<String> words = new LinkedList<String>(Arrays.asList(desc.split("\\s+")));
        String current = "";
        while (!words.isEmpty()) {
            String word = words.getFirst();
            if (current.length() == 0 || current.length() + word.length() < max) {
                if (current.length() != 0) {
                    current = current + " ";
                }
                current = current + word;
                words.removeFirst();
                continue;
            }
            lines.add(current);
            current = "";
        }
        if (current.length() != 0) {
            lines.add(current);
        }
        return lines.toArray(new String[lines.size()]);
    }
}

