/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.DotDirectiveArchiveFinalizer;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.util.FilterSupport;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoArchivedResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxyResourceCollection;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractArchiver
extends AbstractLogEnabled
implements Archiver,
Contextualizable,
FilterEnabled,
FinalizerEnabled {
    private Logger logger;
    private File destFile;
    private List resources = new ArrayList();
    private boolean includeEmptyDirs = true;
    private int fileMode = -1;
    private int directoryMode = -1;
    private int defaultFileMode = -1;
    private int defaultDirectoryMode = -1;
    private boolean forced = true;
    private FilterSupport filterSupport;
    private List finalizers;
    private File dotFileDirectory;
    private String duplicateBehavior = "skip";
    private ArchiverManager archiverManager;

    public String getDuplicateBehavior() {
        return this.duplicateBehavior;
    }

    public void setDuplicateBehavior(String duplicate) {
        if (!Archiver.DUPLICATES_VALID_BEHAVIORS.contains(duplicate)) {
            throw new IllegalArgumentException("Invalid duplicate-file behavior: '" + duplicate + "'. Please specify one of: " + Archiver.DUPLICATES_VALID_BEHAVIORS);
        }
        this.duplicateBehavior = duplicate;
    }

    public final void setFileMode(int mode) {
        this.fileMode = mode & 0xFFF | 0x8000;
    }

    public final void setDefaultFileMode(int mode) {
        this.defaultFileMode = mode & 0xFFF | 0x8000;
    }

    public final int getOverrideFileMode() {
        return this.fileMode;
    }

    public final int getFileMode() {
        if (this.fileMode < 0) {
            if (this.defaultFileMode < 0) {
                return 33188;
            }
            return this.defaultFileMode;
        }
        return this.fileMode;
    }

    public final int getDefaultFileMode() {
        return this.defaultFileMode;
    }

    public final int getRawDefaultFileMode() {
        return this.getDefaultFileMode();
    }

    public final void setDirectoryMode(int mode) {
        this.directoryMode = mode & 0xFFF | 0x4000;
    }

    public final void setDefaultDirectoryMode(int mode) {
        this.defaultDirectoryMode = mode & 0xFFF | 0x4000;
    }

    public final int getOverrideDirectoryMode() {
        return this.directoryMode;
    }

    public final int getDirectoryMode() {
        if (this.directoryMode < 0) {
            if (this.defaultDirectoryMode < 0) {
                return 16877;
            }
            return this.defaultDirectoryMode;
        }
        return this.directoryMode;
    }

    public final int getDefaultDirectoryMode() {
        return this.defaultDirectoryMode;
    }

    public final int getRawDefaultDirectoryMode() {
        return this.getDefaultDirectoryMode();
    }

    public boolean getIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public void addDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, "");
    }

    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.addDirectory(directory, prefix, null, null);
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directory, "", includes, excludes);
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(directory);
        fileSet.setPrefix(prefix);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setIncludingEmptyDirectories(this.includeEmptyDirs);
        this.addFileSet(fileSet);
    }

    public void addFileSet(FileSet fileSet) throws ArchiverException {
        File directory = fileSet.getDirectory();
        if (directory == null) {
            throw new ArchiverException("The file sets base directory is null.");
        }
        if (!directory.isDirectory()) {
            throw new ArchiverException(directory.getAbsolutePath() + " isn't a directory.");
        }
        PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection(this.getLogger());
        collection.setIncludes(fileSet.getIncludes());
        collection.setExcludes(fileSet.getExcludes());
        collection.setBaseDir(directory);
        collection.setFileSelectors(fileSet.getFileSelectors());
        collection.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        collection.setPrefix(fileSet.getPrefix());
        collection.setCaseSensitive(fileSet.isCaseSensitive());
        collection.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        if (this.getOverrideDirectoryMode() > -1 || this.getOverrideFileMode() > -1) {
            collection.setOverrideAttributes(-1, null, -1, null, this.getOverrideFileMode(), this.getOverrideDirectoryMode());
        }
        if (this.getDefaultDirectoryMode() > -1 || this.getDefaultFileMode() > -1) {
            collection.setDefaultAttributes(-1, null, -1, null, this.getDefaultFileMode(), this.getDefaultDirectoryMode());
        }
        this.addResources(collection);
    }

    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        int fileMode = this.getOverrideFileMode();
        this.addFile(inputFile, destFileName, fileMode);
    }

    protected ArchiveEntry asArchiveEntry(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        if (!resource.isExisting()) {
            throw new ArchiverException(resource.getName() + " not found.");
        }
        if (resource.isFile()) {
            return ArchiveEntry.createFileEntry(destFileName, resource, permissions);
        }
        return ArchiveEntry.createDirectoryEntry(destFileName, resource, permissions);
    }

    protected ArchiveEntry asArchiveEntry(PlexusIoResourceCollection collection, PlexusIoResource resource) throws ArchiverException {
        try {
            PlexusIoResourceAttributes attrs;
            String destFileName = collection.getName(resource);
            int permissions = -1;
            if (resource instanceof PlexusIoResourceWithAttributes && (attrs = ((PlexusIoResourceWithAttributes)resource).getAttributes()) != null) {
                permissions = attrs.getOctalMode();
            }
            return this.asArchiveEntry(resource, destFileName, permissions);
        }
        catch (IOException e) {
            throw new ArchiverException(e.getMessage(), e);
        }
    }

    public void addResource(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        this.resources.add(this.asArchiveEntry(resource, destFileName, permissions));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(File inputFile, String destFileName, int permissions) throws ArchiverException {
        FileInputStream fileStream;
        block9: {
            if (!inputFile.isFile()) throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
            if (!inputFile.exists()) {
                throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
            }
            fileStream = null;
            destFileName = destFileName.replace('\\', '/');
            if (permissions < 0) {
                permissions = this.getOverrideFileMode();
            }
            try {
                if (this.filterSupport != null) {
                    fileStream = new FileInputStream(inputFile);
                    if (this.include(fileStream, destFileName)) {
                        this.resources.add(ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
                    }
                    break block9;
                }
                this.resources.add(ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
            }
            catch (IOException e) {
                try {
                    throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e);
                    catch (ArchiveFilterException e2) {
                        throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileStream);
                    throw throwable;
                }
            }
        }
        IOUtil.close(fileStream);
    }

    public ResourceIterator getResources() throws ArchiverException {
        return new ResourceIterator(){
            private final Iterator addedResourceIter;
            private PlexusIoResourceCollection currentResourceCollection;
            private Iterator ioResourceIter;
            private ArchiveEntry nextEntry;
            private Set seenEntries;
            {
                this.addedResourceIter = AbstractArchiver.this.resources.iterator();
                this.seenEntries = new HashSet();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean hasNext() throws ArchiverException {
                block12: {
                    if (this.nextEntry == null) {
                        if (this.ioResourceIter == null) {
                            if (this.addedResourceIter.hasNext()) {
                                Object o = this.addedResourceIter.next();
                                if (o instanceof ArchiveEntry) {
                                    this.nextEntry = (ArchiveEntry)o;
                                    break block12;
                                } else {
                                    if (!(o instanceof PlexusIoResourceCollection)) throw new IllegalStateException("An invalid resource of type: " + o.getClass().getName() + " was added to archiver: " + this.getClass().getName());
                                    this.currentResourceCollection = (PlexusIoResourceCollection)o;
                                    try {
                                        this.ioResourceIter = this.currentResourceCollection.getResources();
                                        return this.hasNext();
                                    }
                                    catch (IOException e) {
                                        throw new ArchiverException(e.getMessage(), e);
                                    }
                                }
                            }
                            this.nextEntry = null;
                        } else {
                            if (!this.ioResourceIter.hasNext()) {
                                this.ioResourceIter = null;
                                return this.hasNext();
                            }
                            PlexusIoResource resource = (PlexusIoResource)this.ioResourceIter.next();
                            this.nextEntry = AbstractArchiver.this.asArchiveEntry(this.currentResourceCollection, resource);
                        }
                    }
                }
                if (this.nextEntry != null && this.seenEntries.contains(this.nextEntry.getName())) {
                    String path = this.nextEntry.getName();
                    if ("preserve".equals(AbstractArchiver.this.duplicateBehavior) || "skip".equals(AbstractArchiver.this.duplicateBehavior)) {
                        AbstractArchiver.this.getLogger().info(path + " already added, skipping");
                        this.nextEntry = null;
                        return this.hasNext();
                    }
                    if ("fail".equals(AbstractArchiver.this.duplicateBehavior)) {
                        throw new ArchiverException("Duplicate file " + path + " was found and the duplicate " + "attribute is 'fail'.");
                    }
                    AbstractArchiver.this.getLogger().debug("duplicate file " + path + " found, adding.");
                }
                if (this.nextEntry == null) return false;
                return true;
            }

            public ArchiveEntry next() throws ArchiverException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArchiveEntry next = this.nextEntry;
                this.nextEntry = null;
                this.seenEntries.add(next.getName());
                return next;
            }
        };
    }

    public Map getFiles() {
        try {
            HashMap<String, ArchiveEntry> map = new HashMap<String, ArchiveEntry>();
            ResourceIterator iter = this.getResources();
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                if (!this.includeEmptyDirs && entry.getType() != 1) continue;
                map.put(entry.getName(), entry);
            }
            return map;
        }
        catch (ArchiverException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
        if (destFile != null) {
            destFile.getParentFile().mkdirs();
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = super.getLogger() != null ? super.getLogger() : new ConsoleLogger(1, "console");
        }
        return this.logger;
    }

    public Map getDirs() {
        try {
            HashMap<String, ArchiveEntry> map = new HashMap<String, ArchiveEntry>();
            ResourceIterator iter = this.getResources();
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                if (entry.getType() != 2) continue;
                map.put(entry.getName(), entry);
            }
            return map;
        }
        catch (ArchiverException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    protected PlexusIoResourceCollection asResourceCollection(ArchivedFileSet fileSet) throws ArchiverException {
        PlexusIoResourceCollection resources;
        File archiveFile = fileSet.getArchive();
        try {
            resources = this.archiverManager.getResourceCollection(archiveFile);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiverException("Error adding archived file-set. PlexusIoResourceCollection not found for: " + archiveFile, e);
        }
        if (!(resources instanceof PlexusIoArchivedResourceCollection)) {
            throw new ArchiverException("Expected " + PlexusIoArchivedResourceCollection.class.getName() + ", got " + resources.getClass().getName());
        }
        ((PlexusIoArchivedResourceCollection)resources).setFile(fileSet.getArchive());
        PlexusIoProxyResourceCollection proxy = new PlexusIoProxyResourceCollection();
        proxy.setSrc(resources);
        proxy.setExcludes(fileSet.getExcludes());
        proxy.setIncludes(fileSet.getIncludes());
        proxy.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        proxy.setCaseSensitive(fileSet.isCaseSensitive());
        proxy.setPrefix(fileSet.getPrefix());
        proxy.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        proxy.setFileSelectors(fileSet.getFileSelectors());
        if (this.getOverrideDirectoryMode() > -1 || this.getOverrideFileMode() > -1) {
            proxy.setOverrideAttributes(-1, null, -1, null, this.getOverrideFileMode(), this.getOverrideDirectoryMode());
        }
        if (this.getDefaultDirectoryMode() > -1 || this.getDefaultFileMode() > -1) {
            proxy.setDefaultAttributes(-1, null, -1, null, this.getDefaultFileMode(), this.getDefaultDirectoryMode());
        }
        return proxy;
    }

    public void addResources(PlexusIoResourceCollection collection) throws ArchiverException {
        this.resources.add(collection);
    }

    public void addArchivedFileSet(ArchivedFileSet fileSet) throws ArchiverException {
        PlexusIoResourceCollection resourceCollection = this.asResourceCollection(fileSet);
        this.addResources(resourceCollection);
    }

    public void addArchivedFileSet(File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        DefaultArchivedFileSet fileSet = new DefaultArchivedFileSet();
        fileSet.setArchive(archiveFile);
        fileSet.setPrefix(prefix);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setIncludingEmptyDirectories(this.includeEmptyDirs);
        this.addArchivedFileSet(fileSet);
    }

    public void addArchivedFileSet(File archiveFile, String prefix) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, prefix, null, null);
    }

    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, null, includes, excludes);
    }

    public void addArchivedFileSet(File archiveFile) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, null, null, null);
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get("plexus");
        try {
            this.archiverManager = (ArchiverManager)container.lookup(ArchiverManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ContextException("Error retrieving ArchiverManager instance: " + e.getMessage(), e);
        }
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void setArchiveFilters(List filters) {
        this.filterSupport = new FilterSupport(filters, this.getLogger());
    }

    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList();
        }
        this.finalizers.add(finalizer);
    }

    public void setArchiveFinalizers(List archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    public void setDotFileDirectory(File dotFileDirectory) {
        this.dotFileDirectory = dotFileDirectory;
    }

    protected boolean isUptodate() throws ArchiverException {
        File zipFile = this.getDestFile();
        long destTimestamp = zipFile.lastModified();
        if (destTimestamp == 0L) {
            this.getLogger().debug("isUp2date: false (Destination " + zipFile.getPath() + " not found.)");
            return false;
        }
        Iterator it = this.resources.iterator();
        if (!it.hasNext()) {
            this.getLogger().debug("isUp2date: false (No input files.)");
            return false;
        }
        while (it.hasNext()) {
            long l;
            Object o = it.next();
            if (o instanceof ArchiveEntry) {
                l = ((ArchiveEntry)o).getResource().getLastModified();
            } else if (o instanceof PlexusIoResourceCollection) {
                try {
                    l = ((PlexusIoResourceCollection)o).getLastModified();
                }
                catch (IOException e) {
                    throw new ArchiverException(e.getMessage(), e);
                }
            } else {
                throw new IllegalStateException("Invalid object type: " + o.getClass().getName());
            }
            if (l == 0L) {
                this.getLogger().debug("isUp2date: false (Resource with unknown modification date found.)");
                return false;
            }
            if (l <= destTimestamp) continue;
            this.getLogger().debug("isUp2date: false (Resource with newer modification date found.)");
            return false;
        }
        this.getLogger().debug("isUp2date: true");
        return true;
    }

    protected boolean checkForced() throws ArchiverException {
        if (!this.isForced() && this.isSupportingForced() && this.isUptodate()) {
            this.getLogger().debug("Archive " + this.getDestFile() + " is uptodate.");
            return false;
        }
        return true;
    }

    public boolean isSupportingForced() {
        return false;
    }

    protected List getArchiveFinalizers() {
        return this.finalizers;
    }

    protected void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                finalizer.finalizeArchiveCreation(this);
            }
        }
    }

    private boolean include(InputStream in, String path) throws ArchiveFilterException {
        return this.filterSupport == null || this.filterSupport.include(in, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createArchive() throws ArchiverException, IOException {
        this.validate();
        try {
            try {
                if (this.dotFileDirectory != null) {
                    this.addArchiveFinalizer(new DotDirectiveArchiveFinalizer(this.dotFileDirectory));
                }
                this.runArchiveFinalizers();
                this.execute();
            }
            finally {
                this.close();
            }
        }
        catch (IOException e) {
            String msg = "Problem creating " + this.getArchiveType() + ": " + e.getMessage();
            StringBuffer revertBuffer = new StringBuffer();
            if (!this.revert(revertBuffer)) {
                msg = msg + revertBuffer.toString();
            }
            throw new ArchiverException(msg, e);
        }
        finally {
            this.cleanUp();
        }
    }

    protected boolean hasVirtualFiles() {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                List virtualFiles = finalizer.getVirtualFiles();
                if (virtualFiles == null || virtualFiles.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean revert(StringBuffer messageBuffer) {
        return true;
    }

    protected void validate() throws ArchiverException, IOException {
    }

    protected abstract String getArchiveType();

    protected abstract void close() throws IOException;

    protected void cleanUp() {
        this.resources.clear();
    }

    protected abstract void execute() throws ArchiverException, IOException;
}

