/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.osgi.ServiceConstants;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.internal.FabConnectionFactory;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.ops4j.pax.url.commons.handler.ConnectionFactory;
import org.ops4j.pax.url.commons.handler.HandlerActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends HandlerActivator<Configuration> {
    private static Activator instance;
    private BundleContext bundleContext;
    private ConfigAdmin configAdmin;
    public static OsgiModuleRegistry registry;

    public static Activator getInstance() {
        return instance;
    }

    public static BundleContext getInstanceBundleContext() {
        Activator activator = Activator.getInstance();
        if (activator != null) {
            return activator.getBundleContext();
        }
        return null;
    }

    public Activator() {
        super(ServiceConstants.PROTOCOLS_SUPPORTED, "io.fabric8.fab.osgi.url", (ConnectionFactory)new FabConnectionFactory());
        instance = this;
    }

    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configAdmin = new ConfigAdmin();
        this.configAdmin.open();
        File data = new File(System.getProperty("karaf.data", "."));
        registry.setDirectory(new File(data, "fab-module-registry"));
        registry.setConfigurationAdmin(new ConfigAdmin());
        registry.setPid("io.fabric8.fab.osgi.registry");
        registry.load();
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) {
        this.configAdmin.close();
        super.stop(bundleContext);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    static {
        registry = new OsgiModuleRegistry();
    }

    public class ConfigAdmin
    extends ServiceTracker<ConfigurationAdmin, ConfigurationAdmin>
    implements ConfigurationAdmin {
        public ConfigAdmin() {
            super(Activator.this.bundleContext, ConfigurationAdmin.class, null);
        }

        private ConfigurationAdmin getConfigAdmin() throws IOException {
            try {
                ConfigurationAdmin ca = (ConfigurationAdmin)this.waitForService(5000L);
                if (ca != null) {
                    return ca;
                }
                throw new IllegalStateException("ConfigurationAdmin not present");
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("ConfigurationAdmin not present").initCause(e);
            }
        }

        public org.osgi.service.cm.Configuration createFactoryConfiguration(String factoryPid) throws IOException {
            return this.getConfigAdmin().createFactoryConfiguration(factoryPid);
        }

        public org.osgi.service.cm.Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
            return this.getConfigAdmin().createFactoryConfiguration(factoryPid, location);
        }

        public org.osgi.service.cm.Configuration getConfiguration(String pid, String location) throws IOException {
            return this.getConfigAdmin().getConfiguration(pid, location);
        }

        public org.osgi.service.cm.Configuration getConfiguration(String pid) throws IOException {
            return this.getConfigAdmin().getConfiguration(pid);
        }

        public org.osgi.service.cm.Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
            return this.getConfigAdmin().listConfigurations(filter);
        }
    }
}

