/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AttributeParser
implements StreamConsumer {
    protected static final Pattern LINE_SPLITTER = Pattern.compile("\\s+");
    protected static final int[] LS_LAST_DATE_PART_INDICES = new int[]{7, 7, 6};
    protected final StreamConsumer delegate;
    protected final Map<String, PlexusIoResourceAttributes> attributesByPath = new LinkedHashMap<String, PlexusIoResourceAttributes>();
    private final Logger logger;
    private boolean nextIsPathPrefix = false;
    private String pathPrefix = "";
    private final SimpleDateFormat[] LS_DATE_FORMATS;

    public AttributeParser(StreamConsumer delegate, Logger logger) {
        this.delegate = delegate;
        this.logger = logger;
        this.LS_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("MMM dd yyyy"), new SimpleDateFormat("MMM dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeLine(String line) {
        if (!PlexusIoResourceAttributeUtils.totalLinePattern.matcher(line).matches()) {
            if (line.trim().length() == 0) {
                this.nextIsPathPrefix = true;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Anticipating path prefix in next line");
                }
            } else if (this.nextIsPathPrefix) {
                if (!line.endsWith(":")) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Path prefix not found. Checking next line.");
                    }
                } else {
                    this.nextIsPathPrefix = false;
                    this.pathPrefix = line.substring(0, line.length() - 1);
                    if (!this.pathPrefix.endsWith("/")) {
                        this.pathPrefix = this.pathPrefix + "/";
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Set path prefix to: " + this.pathPrefix);
                    }
                }
            } else {
                String[] parts = LINE_SPLITTER.split(line);
                int lastDatePart = this.verifyParsability(line, parts, this.logger);
                if (lastDatePart > 0) {
                    int idx = line.indexOf(parts[lastDatePart]) + parts[lastDatePart].length() + 1;
                    String path = this.pathPrefix + line.substring(idx);
                    while (path.length() > 0 && Character.isWhitespace(path.charAt(0))) {
                        path = path.substring(1);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("path: '" + path + "'");
                        this.logger.debug("mode: '" + parts[0] + "'");
                        this.logger.debug("uid: '" + parts[2]);
                        this.logger.debug("gid: '" + parts[3]);
                    }
                    Map<String, PlexusIoResourceAttributes> map = this.attributesByPath;
                    synchronized (map) {
                        FileAttributes attributes = new FileAttributes();
                        attributes.setLsModeline(parts[0]);
                        this.attributesByPath.put(path, attributes);
                        this.processAttributes(attributes, parts);
                    }
                }
            }
        }
        this.delegate.consumeLine(line);
    }

    protected abstract void processAttributes(FileAttributes var1, String[] var2);

    public Map<String, PlexusIoResourceAttributes> getAttributesByPath() {
        return this.attributesByPath;
    }

    private int verifyParsability(String line, String[] parts, Logger logger) {
        if (parts.length > 7) {
            String dateCandidate = parts[5] + " " + parts[6] + " " + parts[7];
            for (int i = 0; i < this.LS_DATE_FORMATS.length; ++i) {
                try {
                    this.LS_DATE_FORMATS[i].parse(dateCandidate);
                    return LS_LAST_DATE_PART_INDICES[i];
                }
                catch (ParseException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to parse date: '" + dateCandidate + "' using format: " + this.LS_DATE_FORMATS[i].toPattern(), e);
                    continue;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Unparseable line: '" + line + "'\nReason: unrecognized date format; ambiguous start-index for path in listing.");
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SymbolicUserIDAttributeParser
    extends AttributeParser {
        SymbolicUserIDAttributeParser(StreamConsumer delegate, Logger logger) {
            super(delegate, logger);
        }

        @Override
        protected void processAttributes(FileAttributes attributes, String[] parts) {
            attributes.setUserName(parts[2]);
            attributes.setGroupName(parts[3]);
        }

        public Map<String, PlexusIoResourceAttributes> merge(NumericUserIDAttributeParser otherParser) {
            Map<String, PlexusIoResourceAttributes> attributes = this.getAttributesByPath();
            if (otherParser == null) {
                return attributes;
            }
            HashMap<String, PlexusIoResourceAttributes> result = new HashMap<String, PlexusIoResourceAttributes>();
            Map<String, PlexusIoResourceAttributes> otherAttributes = otherParser.getAttributesByPath();
            HashSet<String> allKeys = new HashSet<String>(attributes.keySet());
            allKeys.addAll(otherAttributes.keySet());
            for (String key : allKeys) {
                PlexusIoResourceAttributes thisAttribute = attributes.get(key);
                PlexusIoResourceAttributes otherAttribute = otherAttributes.get(key);
                if (thisAttribute == null) {
                    thisAttribute = otherAttribute;
                }
                if (thisAttribute != null && otherAttribute != null) {
                    thisAttribute.setUserId(otherAttribute.getUserId());
                    thisAttribute.setGroupId(otherAttribute.getGroupId());
                }
                result.put(key, thisAttribute);
            }
            return result;
        }
    }

    static class NumericUserIDAttributeParser
    extends AttributeParser {
        NumericUserIDAttributeParser(StreamConsumer delegate, Logger logger) {
            super(delegate, logger);
        }

        protected void processAttributes(FileAttributes attributes, String[] parts) {
            attributes.setUserId((int)Long.parseLong(parts[2]));
            attributes.setGroupId((int)Long.parseLong(parts[3]));
        }
    }
}

