/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DotDirectiveArchiveFinalizer
extends AbstractArchiveFinalizer {
    private static String DEFAULT_DOT_FILE_PREFIX = ".plxarc";
    private File dotFileDirectory;
    private String dotFilePrefix;

    public DotDirectiveArchiveFinalizer(File dotFileDirectory) {
        this(dotFileDirectory, DEFAULT_DOT_FILE_PREFIX);
    }

    public DotDirectiveArchiveFinalizer(File dotFileDirectory, String dotFilePrefix) {
        this.dotFileDirectory = dotFileDirectory;
        this.dotFilePrefix = dotFilePrefix;
    }

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        try {
            List dotFiles = FileUtils.getFiles(this.dotFileDirectory, this.dotFilePrefix + "*", null);
            for (File dotFile : dotFiles) {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(dotFile));
                while ((line = in.readLine()) != null) {
                    File directory;
                    String[] s = StringUtils.split(line, ":");
                    if (s.length == 1) {
                        directory = new File(this.dotFileDirectory, s[0]);
                        System.out.println("adding directory = " + directory);
                        archiver.addDirectory(directory);
                        continue;
                    }
                    directory = new File(this.dotFileDirectory, s[0]);
                    System.out.println("adding directory = " + directory + " to: " + s[1]);
                    if (s[1].endsWith("/")) {
                        archiver.addDirectory(directory, s[1]);
                        continue;
                    }
                    archiver.addDirectory(directory, s[1] + "/");
                }
                in.close();
            }
        }
        catch (IOException e) {
            throw new ArchiverException("Error processing dot files.", e);
        }
    }

    public List getVirtualFiles() {
        return Collections.EMPTY_LIST;
    }
}

