/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import aQute.bnd.osgi.Jar;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Manifests;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.fab.DependencyFilters;
import io.fabric8.fab.DependencyId;
import io.fabric8.fab.DependencyTreeFilters;
import io.fabric8.fab.MavenResolver;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DependencyTree
implements Comparable<DependencyTree> {
    private static final transient Logger LOG = LoggerFactory.getLogger(DependencyTree.class);
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DependencyId dependencyId;
    private final String version;
    private String url;
    private final List<DependencyTree> children;
    private final int hashCode;
    private String scope;
    private File jarFile;
    private boolean optional;
    private Set<String> packages;
    private Set<String> hiddenPackages = new HashSet<String>();
    private DependencyTree parent;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String groupId, String artifactId, String version) {
        Builder builder = new Builder();
        builder.setGroupId(groupId);
        builder.setArtifactId(artifactId);
        builder.setVersion(version);
        return builder;
    }

    public static Builder newBuilder(String groupId, String artifactId, String version, DependencyTree ... children) {
        Builder builder = DependencyTree.newBuilder(groupId, artifactId, version);
        builder.getChildren().addAll(Arrays.asList(children));
        return builder;
    }

    public static DependencyTree unmarshal(String text) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(text)));
        return DependencyTree.unmarshal(document.getDocumentElement());
    }

    public static DependencyTree unmarshal(Element element) {
        Builder builder = DependencyTree.newBuilder();
        builder.setGroupId(element.getAttribute("groupId"));
        builder.setArtifactId(element.getAttribute("artifactId"));
        builder.setClassifier(element.getAttribute("classifier"));
        builder.setExtension(element.getAttribute("extension"));
        builder.setVersion(element.getAttribute("version"));
        builder.setUrl(element.getAttribute("url"));
        List<DependencyTree> builderChildren = builder.getChildren();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element child;
            DependencyTree childTree;
            Node item = nodeList.item(i);
            if (!(item instanceof Element) || (childTree = DependencyTree.unmarshal(child = (Element)item)) == null) continue;
            builderChildren.add(childTree);
        }
        return builder.build();
    }

    public static DependencyTree newInstance(DependencyNode node, MavenResolver resolver, Filter<Dependency> excludeDependencyFilter) throws MalformedURLException, ArtifactResolutionException {
        List<DependencyNode> childrenNodes = node.getChildren();
        ArrayList<DependencyTree> children = new ArrayList<DependencyTree>();
        for (DependencyNode childNode : childrenNodes) {
            if (DependencyFilters.matches(childNode, excludeDependencyFilter) || node.getDependency().equals(childNode.getDependency())) continue;
            DependencyTree child = DependencyTree.newInstance(childNode, resolver, excludeDependencyFilter);
            children.add(child);
        }
        Artifact artifact = node.getDependency().getArtifact();
        DependencyTree dependencyTree = new DependencyTree(DependencyId.newInstance(artifact), node.getDependency(), children);
        File file = artifact.getFile();
        if (file == null) {
            file = resolver.resolveFile(artifact);
        }
        if (file != null) {
            String url = file.toURI().toURL().toExternalForm();
            dependencyTree.setUrl(url);
        }
        return dependencyTree;
    }

    public DependencyTree(DependencyId dependencyId, Dependency dependency, List<DependencyTree> children) {
        this(dependencyId, dependency.getArtifact().getBaseVersion(), children);
        this.scope = dependency.getScope();
        this.optional = dependency.isOptional();
        this.init(children);
    }

    private void init(List<DependencyTree> children) {
        for (DependencyTree child : children) {
            child.parent = this;
        }
    }

    public DependencyTree(DependencyId dependencyId, String version, List<DependencyTree> children) {
        this.dependencyId = dependencyId;
        this.version = version;
        ArrayList<DependencyTree> sortedChildren = new ArrayList<DependencyTree>(children);
        Collections.sort(sortedChildren);
        this.children = sortedChildren;
        this.hashCode = Objects.hashCode((Object[])new Object[]{dependencyId, version, this.children});
        this.init(children);
    }

    public URL getJarURL() throws MalformedURLException {
        File file;
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalArgumentException("No Url supplied for " + this);
        }
        if (url.startsWith("file:")) {
            url = url.substring("file:".length());
        }
        URL u = (file = new File(url)).exists() ? file.toURI().toURL() : new URL(url);
        return u;
    }

    public String toString() {
        String classifier = this.getClassifier();
        String extension = this.getExtension();
        return "DependencyTree(" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.version + ":" + (Strings.notEmpty((String)classifier) ? ":" + classifier : "") + (Strings.notEmpty((String)extension) ? ":" + extension : "") + this.children + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DependencyTree) {
            DependencyTree that = (DependencyTree)o;
            return this.hashCode() == that.hashCode() && Objects.equal((Object)this.dependencyId, (Object)that.dependencyId) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal(this.children, that.children);
        }
        return false;
    }

    @Override
    public int compareTo(DependencyTree that) {
        int answer = Objects.compare((Comparable)this.dependencyId, (Comparable)that.dependencyId);
        if (answer == 0) {
            answer = Objects.compare((Comparable)((Object)this.version), (Comparable)((Object)that.version));
        }
        if (answer == 0) {
            answer = Objects.compare(this.children, that.children);
        }
        return answer;
    }

    public boolean isValidLibrary() {
        return this.getUrl() != null && !this.getUrl().endsWith(".pom");
    }

    public DependencyTree getParent() {
        return this.parent;
    }

    public boolean isThisOrDescendantOptional() {
        if (this.isOptional()) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isThisOrDescendantOptional();
        }
        return false;
    }

    public DependencyTree findDependency(String groupId, String artifactId) {
        return this.findDependency(groupId + ":" + artifactId);
    }

    public DependencyTree findDependency(String filterText) {
        Filter<DependencyTree> filter = DependencyTreeFilters.parse(filterText);
        return this.findDependency(filter);
    }

    public DependencyTree findDependency(Filter<DependencyTree> filter) {
        if (filter.matches((Object)this)) {
            return this;
        }
        for (DependencyTree child : this.children) {
            DependencyTree dependency = child.findDependency(filter);
            if (dependency == null) continue;
            return dependency;
        }
        return null;
    }

    public String marshal() throws ParserConfigurationException, TransformerException {
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        this.addToDocument(document, document);
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(buffer));
        return buffer.toString();
    }

    protected void addToDocument(Document document, Node parent) {
        Element element = document.createElement("dependency");
        element.setAttribute("groupId", this.getGroupId());
        element.setAttribute("artifactId", this.getArtifactId());
        element.setAttribute("classifier", this.getClassifier());
        element.setAttribute("extension", this.getExtension());
        element.setAttribute("version", this.getVersion());
        if (this.url != null) {
            element.setAttribute("url", this.getUrl());
        }
        parent.appendChild(element);
        for (DependencyTree child : this.children) {
            child.addToDocument(document, element);
        }
    }

    public Map<DependencyId, List<DependencyTree>> getDependencyMap() {
        HashMap<DependencyId, List<DependencyTree>> answer = new HashMap<DependencyId, List<DependencyTree>>();
        DependencyTree.populateMap(answer, this);
        return answer;
    }

    public List<DuplicateDependency> checkForDuplicateDependencies() {
        ArrayList<DuplicateDependency> answer = new ArrayList<DuplicateDependency>();
        Map<DependencyId, List<DependencyTree>> map = this.getDependencyMap();
        for (Map.Entry<DependencyId, List<DependencyTree>> entry : map.entrySet()) {
            DependencyId id = entry.getKey();
            List<DependencyTree> list = entry.getValue();
            if (list.size() <= 1) continue;
            answer.add(new DuplicateDependency(id, list));
        }
        return answer;
    }

    protected static void populateMap(Map<DependencyId, List<DependencyTree>> map, DependencyTree node) {
        DependencyId key = node.getDependencyId();
        List<DependencyTree> list = map.get(key);
        if (list == null) {
            list = new ArrayList<DependencyTree>();
            map.put(key, list);
        }
        if (!list.contains(node)) {
            list.add(node);
        }
        List<DependencyTree> childNodes = node.getChildren();
        for (DependencyTree childNode : childNodes) {
            DependencyTree.populateMap(map, childNode);
        }
    }

    public void dump(StringBuffer buffer) {
        this.displayTree(this, "", buffer);
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        this.dump(buffer);
        return buffer.toString();
    }

    protected void displayTree(DependencyTree node, String indent, StringBuffer buffer) {
        buffer.append(indent + node.getDependencyId() + ":" + node.getVersion()).append("\n");
        String childIndent = indent + "  ";
        for (DependencyTree child : node.getChildren()) {
            this.displayTree(child, childIndent, buffer);
        }
    }

    public DependencyId getDependencyId() {
        return this.dependencyId;
    }

    public String getVersion() {
        return this.version;
    }

    public List<DependencyTree> getChildren() {
        return this.children;
    }

    public List<DependencyTree> getDescendants() {
        ArrayList<DependencyTree> answer = new ArrayList<DependencyTree>();
        this.addDescendants(answer);
        return answer;
    }

    public void addDescendants(List<DependencyTree> list) {
        for (DependencyTree child : this.children) {
            list.add(child);
            child.addDescendants(list);
        }
    }

    public String getGroupId() {
        return this.dependencyId.getGroupId();
    }

    public String getArtifactId() {
        return this.dependencyId.getArtifactId();
    }

    public String getExtension() {
        return this.dependencyId.getExtension();
    }

    public String getClassifier() {
        return this.dependencyId.getClassifier();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getBundleSymbolicName() {
        String bundleId = this.getManifestBundleSymbolicName();
        if (bundleId != null) {
            return bundleId;
        }
        String artifactId = this.getArtifactId();
        if (artifactId.contains(".")) {
            return artifactId;
        }
        return this.getGroupId() + "." + artifactId;
    }

    protected String getManifestBundleSymbolicName() {
        return this.getManifestEntry("Bundle-SymbolicName");
    }

    public String getManifestEntry(String attributeName) {
        try {
            return Manifests.getManifestEntry((File)this.getJarFile(), (String)attributeName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getJarFile() throws IOException {
        if (this.jarFile == null) {
            URL url = this.getJarURL();
            this.jarFile = Files.urlToFile((URL)url, (String)"fabric-tmp-fab-", (String)".jar");
        }
        return this.jarFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public boolean isBundle() {
        return this.getManifestBundleSymbolicName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPackages() throws IOException {
        if (this.packages == null) {
            if (this.getExtension().equals("jar") || this.getExtension().equals("zip")) {
                try (Jar jar = new Jar(this.getJarFile());){
                    this.packages = new HashSet<String>(jar.getPackages());
                }
            } else {
                return Collections.emptySet();
            }
        }
        return this.packages;
    }

    public void addHiddenPackage(String packageName) {
        this.hiddenPackages.add(packageName);
    }

    public boolean isAllPackagesHidden() {
        try {
            Set<String> nonMetaPackages = this.getPackages();
            for (String key : new ArrayList<String>(nonMetaPackages)) {
                if (!key.startsWith("META-INF")) continue;
                nonMetaPackages.remove(key);
            }
            return this.hiddenPackages.containsAll(nonMetaPackages);
        }
        catch (IOException e) {
            return true;
        }
    }

    public boolean isBundleFragment() {
        return this.isBundle() && Strings.notEmpty((String)this.getManifestEntry("Fragment-Host"));
    }

    public static class DuplicateDependency {
        private final DependencyId dependencyId;
        private final List<DependencyTree> dependencyTrees;

        public DuplicateDependency(DependencyId dependencyId, List<DependencyTree> dependencyTrees) {
            this.dependencyId = dependencyId;
            this.dependencyTrees = dependencyTrees;
        }

        public DependencyId getDependencyId() {
            return this.dependencyId;
        }

        public List<DependencyTree> getDependencyTrees() {
            return this.dependencyTrees;
        }

        public String toString() {
            return "Duplicate" + this.dependencyId + this.dependencyTrees;
        }
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier = "";
        private String extension = "jar";
        private String url;
        private List<DependencyTree> children = new ArrayList<DependencyTree>();

        public DependencyTree build() {
            DependencyTree tree = new DependencyTree(new DependencyId(this.groupId, this.artifactId, this.classifier, this.extension), this.version, this.children);
            if (this.url != null) {
                tree.setUrl(this.url);
            }
            return tree;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public List<DependencyTree> getChildren() {
            return this.children;
        }

        public void setChildren(List<DependencyTree> children) {
            this.children = children;
        }
    }
}

