/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.commands.fab;

import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.osgi.commands.fab.FabCommandSupport;
import io.fabric8.fab.osgi.internal.Bundles;
import io.fabric8.fab.osgi.internal.FabClassPathResolver;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="start", scope="fab", description="Starts the Fabric Bundle along with its transitive dependencies")
public class StartCommand
extends FabCommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(StartCommand.class);
    @Option(name="--timeout", description="Maximum time to wait starting the FAB in milliseconds")
    private long timeout = 30000L;
    private transient long startTime;

    public void start(Bundle bundle) throws Exception {
        this.getPackageAdmin();
        this.doExecute(bundle);
    }

    @Override
    protected void doExecute(Bundle bundle, FabClassPathResolver resolver) {
        List<DependencyTree> sharedDependencies = resolver.getSharedDependencies();
        for (int i = sharedDependencies.size() - 1; i >= 0; --i) {
            String version;
            DependencyTree dependency = sharedDependencies.get(i);
            String name = dependency.getBundleSymbolicName();
            Bundle b = Bundles.findBundle(this.bundleContext, name, version = dependency.getVersion());
            if (b == null) continue;
            this.startBundle(b);
        }
        this.startBundle(bundle);
    }

    protected void startBundle(Bundle bundle) {
        int state = bundle.getState();
        if (state == 2 || state == 4 && !Bundles.isFragment(bundle)) {
            LOG.debug("Starting bundle %s version %s", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
            try {
                bundle.start();
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                long end = this.startTime + this.timeout;
                while ((state = bundle.getState()) != 32 && state != 16 && System.currentTimeMillis() <= end) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (BundleException e) {
                System.out.println("Failed to start " + bundle.getSymbolicName() + " " + bundle.getVersion() + ". " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
    }
}

