/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.MavenResolver;
import io.fabric8.fab.MavenResolverImpl;
import io.fabric8.fab.osgi.ServiceConstants;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.util.ConfigurationAdminHelper;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertiesPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private PropertyResolver propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull((Object)propertyResolver, (String)"PropertyResolver");
        this.propertyResolver = propertyResolver;
    }

    public static ConfigurationImpl newInstance() {
        PropertiesPropertyResolver resolver = new PropertiesPropertyResolver(System.getProperties());
        return new ConfigurationImpl((PropertyResolver)resolver);
    }

    public static ConfigurationImpl newInstance(ConfigurationAdmin admin, BundleContext context) {
        DictionaryPropertyResolver resolver = new DictionaryPropertyResolver(ConfigurationAdminHelper.getProperties(admin, "io.fabric8.fab.osgi.url"), (PropertyResolver)new DictionaryPropertyResolver(ConfigurationAdminHelper.getProperties(admin, "org.ops4j.pax.url.mvn"), (PropertyResolver)new BundleContextPropertyResolver(context)));
        return new ConfigurationImpl((PropertyResolver)resolver);
    }

    @Override
    public boolean getCertificateCheck() {
        if (!this.contains("io.fabric8.fab.osgi.url.certificateCheck")) {
            return (Boolean)this.set("io.fabric8.fab.osgi.url.certificateCheck", Boolean.valueOf(this.propertyResolver.get("io.fabric8.fab.osgi.url.certificateCheck")));
        }
        return (Boolean)this.get("io.fabric8.fab.osgi.url.certificateCheck");
    }

    @Override
    public boolean isInstallMissingDependencies() {
        String value;
        if (!this.contains("io.fabric8.fab.osgi.url.installProvidedDependencies") && (value = this.propertyResolver.get("io.fabric8.fab.osgi.url.installProvidedDependencies")) != null) {
            Boolean aBoolean = Boolean.valueOf(value);
            return (Boolean)this.set("io.fabric8.fab.osgi.url.installProvidedDependencies", aBoolean);
        }
        Boolean answer = (Boolean)this.get("io.fabric8.fab.osgi.url.installProvidedDependencies");
        if (answer == null) {
            return true;
        }
        return answer;
    }

    @Override
    public MavenResolver getResolver() {
        String localrepo;
        MavenResolverImpl resolver = new MavenResolverImpl();
        String[] repositories = this.getMavenRepositories();
        if (repositories != null) {
            resolver.setRepositories(repositories);
        }
        if ((localrepo = this.getLocalMavenRepository()) != null) {
            resolver.setLocalRepo(localrepo);
        }
        return resolver;
    }

    public String[] getMavenRepositories() {
        if (!this.contains("org.ops4j.pax.url.mvn.repositories")) {
            String text = this.propertyResolver.get("org.ops4j.pax.url.mvn.repositories");
            String[] repositories = ConfigurationImpl.toArray(text);
            return (String[])this.set("org.ops4j.pax.url.mvn.repositories", repositories);
        }
        return (String[])this.get("org.ops4j.pax.url.mvn.repositories");
    }

    public String getLocalMavenRepository() {
        if (!this.contains("org.ops4j.pax.url.mvn.localRepository")) {
            String text = this.propertyResolver.get("org.ops4j.pax.url.mvn.localRepository");
            return (String)this.set("org.ops4j.pax.url.mvn.localRepository", text);
        }
        return (String)this.get("org.ops4j.pax.url.mvn.localRepository");
    }

    @Override
    public String[] getSharedResourcePaths() {
        if (!this.contains("io.fabric8.fab.osgi.url.sharedResourcePaths")) {
            String text = this.propertyResolver.get("io.fabric8.fab.osgi.url.sharedResourcePaths");
            String[] repositories = text == null || text.length() == 0 ? ServiceConstants.DEFAULT_PROPERTY_SHARED_RESOURCE_PATHS : ConfigurationImpl.toArray(text);
            return (String[])this.set("io.fabric8.fab.osgi.url.sharedResourcePaths", repositories);
        }
        return (String[])this.get("io.fabric8.fab.osgi.url.sharedResourcePaths");
    }

    protected static String[] toArray(String text) {
        String[] answer = null;
        if (text != null) {
            answer = text.split(",");
        }
        return answer;
    }

    protected PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }
}

