/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import java.util.Comparator;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Capability;

public class CandidateComparator
implements Comparator<Capability> {
    @Override
    public int compare(Capability cap1, Capability cap2) {
        int c = 0;
        if (cap1 instanceof BundleCapability && !(cap2 instanceof BundleCapability)) {
            c = -1;
        } else if (!(cap1 instanceof BundleCapability) && cap2 instanceof BundleCapability) {
            c = 1;
        }
        if (c == 0 && cap1.getNamespace().equals("osgi.wiring.bundle")) {
            c = ((Comparable)cap1.getAttributes().get("osgi.wiring.bundle")).compareTo(cap2.getAttributes().get("osgi.wiring.bundle"));
            if (c == 0) {
                Version v1 = !cap1.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("bundle-version");
                Version v2 = !cap2.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("bundle-version");
                c = this.compareVersions(v2, v1);
            }
        } else if (c == 0 && cap1.getNamespace().equals("osgi.wiring.package")) {
            c = ((Comparable)cap1.getAttributes().get("osgi.wiring.package")).compareTo(cap2.getAttributes().get("osgi.wiring.package"));
            if (c == 0) {
                Version v1 = !cap1.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("version");
                Version v2 = !cap2.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("version");
                c = this.compareVersions(v2, v1);
                if (c == 0) {
                    v1 = !cap1.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("bundle-version");
                    v2 = !cap2.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("bundle-version");
                    c = this.compareVersions(v2, v1);
                }
            }
        } else if (c == 0 && cap1.getNamespace().equals("karaf.feature") && (c = ((Comparable)cap1.getAttributes().get("karaf.feature")).compareTo(cap2.getAttributes().get("karaf.feature"))) == 0) {
            Version v1 = !cap1.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("version");
            Version v2 = !cap2.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("version");
            c = this.compareVersions(v2, v1);
        }
        return c;
    }

    private int compareVersions(Version v1, Version v2) {
        int c = v1.getMajor() - v2.getMajor();
        if (c != 0) {
            return c;
        }
        c = v1.getMinor() - v2.getMinor();
        if (c != 0) {
            return c;
        }
        c = v1.getMicro() - v2.getMicro();
        if (c != 0) {
            return c;
        }
        String q1 = this.cleanQualifierForComparison(v1.getQualifier());
        String q2 = this.cleanQualifierForComparison(v2.getQualifier());
        return q1.compareTo(q2);
    }

    private String cleanQualifierForComparison(String qualifier) {
        return qualifier.replaceAll("(redhat-[0-9]{3})([0-9]{3})", "$1-$2");
    }
}

